/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer;

import java.util.List;
import javax.management.ObjectName;
import org.jboss.system.ServiceConfigurator;
import org.jboss.system.ServiceController;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.microcontainer.ServiceControllerContext;
import org.jboss.system.microcontainer.ServiceControllerContextAction;

public class ConfigureAction
extends ServiceControllerContextAction {
    public void installAction(ServiceControllerContext context) throws Throwable {
        ServiceMetaData metaData = context.getServiceMetaData();
        if (metaData != null) {
            ServiceController controller = context.getServiceController();
            ObjectName objectName = context.getObjectName();
            List<ServiceAttributeMetaData> attrs = metaData.getAttributes();
            if (attrs.size() > 0) {
                ObjectName classLoaderName = metaData.getClassLoaderName();
                ServiceConfigurator.configure(null, controller, objectName, classLoaderName, attrs);
            }
        }
        context.getServiceContext().state = 1;
    }

    public void uninstallAction(ServiceControllerContext context) {
        ServiceMetaData metaData = context.getServiceMetaData();
        if (metaData != null) {
            ServiceController controller = context.getServiceController();
            ObjectName objectName = context.getObjectName();
            List<ServiceAttributeMetaData> attrs = metaData.getAttributes();
            if (attrs.size() > 0) {
                ObjectName classLoaderName = metaData.getClassLoaderName();
                try {
                    ServiceConfigurator.unconfigure(null, controller, objectName, classLoaderName, attrs);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }
}

