/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.remoting3.stream.StreamContext;
import org.jboss.remoting3.stream.StreamHandler;
import org.jboss.remoting3.stream.StreamHandlerFactory;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelInputStream;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSourceChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutputStreamHandlerFactory
implements StreamHandlerFactory<OutputStream, StreamChannel> {
    @Override
    public StreamHandler<OutputStream, StreamChannel> createStreamHandler(OutputStream localInstance, StreamContext streamContext) throws IOException {
        return new Handler(localInstance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProxyOutputStream
    extends OutputStream {
        private final ByteBuffer buffer = ByteBuffer.allocate(1024);
        private final IoFuture<? extends StreamChannel> futureChannel;
        private final Lock lock = new ReentrantLock();
        private boolean open = true;

        private ProxyOutputStream(IoFuture<? extends StreamChannel> channel) {
            this.futureChannel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Lock lock = this.lock;
            try {
                lock.lockInterruptibly();
                try {
                    this.checkOpen();
                    ByteBuffer buffer = this.buffer;
                    buffer.put((byte)b);
                    if (!buffer.hasRemaining()) {
                        this.flush();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException e) {
                this.doInterrupted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Lock lock = this.lock;
            try {
                lock.lockInterruptibly();
                try {
                    this.checkOpen();
                    ByteBuffer buffer = this.buffer;
                    while (len > 0) {
                        int cnt = Math.min(len, buffer.remaining());
                        buffer.put(b, off, cnt);
                        off += cnt;
                        len -= cnt;
                        if (buffer.hasRemaining()) continue;
                        this.flush();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException e) {
                this.doInterrupted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Lock lock = this.lock;
            try {
                lock.lockInterruptibly();
                try {
                    this.checkOpen();
                    StreamChannel channel = (StreamChannel)this.futureChannel.get();
                    ByteBuffer buffer = this.buffer;
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        if (channel.write(buffer) != 0) continue;
                        channel.awaitWritable();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException e) {
                this.doInterrupted();
            }
        }

        @Override
        public void close() throws IOException {
            Lock lock = this.lock;
            lock.lock();
            try {
                if (!this.open) {
                    return;
                }
                StreamChannel channel = (StreamChannel)this.futureChannel.get();
                try {
                    this.flush();
                    channel.shutdownWrites();
                    ChannelInputStream is = new ChannelInputStream((StreamSourceChannel)channel);
                    int b = is.read();
                    switch (b) {
                        case -1: {
                            throw new IOException("Stream outcome unknown");
                        }
                        case 0: {
                            InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
                            StringBuilder builder = new StringBuilder("Remote failure: ");
                            do {
                                if ((b = reader.read()) == -1) continue;
                                builder.append(b);
                            } while (b != -1);
                            throw new IOException(builder.toString());
                        }
                        case 1: {
                            return;
                        }
                    }
                    throw new IOException("Unknown response from remote host");
                }
                finally {
                    IoUtils.safeClose((Closeable)channel);
                }
            }
            finally {
                this.open = false;
                lock.unlock();
            }
        }

        private void doInterrupted() throws InterruptedIOException {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("I/O operation interrupted");
        }

        private void checkOpen() throws IOException {
            if (!this.open) {
                throw new IOException("Write to closed stream");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalHandler
    implements ChannelListener<StreamChannel> {
        private final OutputStream localInstance;
        private final byte[] bytes = new byte[1024];

        private LocalHandler(OutputStream instance) {
            this.localInstance = instance;
        }

        public void handleEvent(StreamChannel channel) {
            channel.getCloseSetter().set((ChannelListener)new ChannelListener<StreamChannel>(){

                public void handleEvent(StreamChannel channel) {
                    IoUtils.safeClose((Closeable)LocalHandler.this.localInstance);
                }
            });
            channel.getReadSetter().set((ChannelListener)new ChannelListener<StreamChannel>(){

                public void handleEvent(StreamChannel channel) {
                    byte[] bytes = LocalHandler.this.bytes;
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    try {
                        while (true) {
                            int res;
                            if ((res = channel.read(buffer)) == 0) {
                                channel.resumeReads();
                                return;
                            }
                            LocalHandler.this.localInstance.write(bytes, 0, buffer.position());
                            buffer.clear();
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel);
                        return;
                    }
                }
            });
            channel.resumeReads();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Handler
    implements StreamHandler<OutputStream, StreamChannel> {
        private static final long serialVersionUID = 3147719591239403750L;
        private final transient OutputStream localInstance;

        private Handler(OutputStream instance) {
            this.localInstance = instance;
        }

        @Override
        public ChannelListener<StreamChannel> getLocalHandler() {
            return new LocalHandler(this.localInstance);
        }

        @Override
        public ChannelListener<Channel> getRemoteHandler() {
            return IoUtils.nullChannelListener();
        }

        @Override
        public OutputStream getRemoteProxy(IoFuture<? extends StreamChannel> futureChannel) {
            return new ProxyOutputStream(futureChannel);
        }
    }
}

