/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.marshalling.NioByteInput;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

final class InboundStream {
    private final int id;
    private final RemoteConnection remoteConnection;
    private final Receiver receiver;
    private State state = State.WAITING_FIRST;
    private static final Logger log = Loggers.main;

    InboundStream(int id, RemoteConnection remoteConnection, Receiver receiver) {
        this.id = id;
        this.remoteConnection = remoteConnection;
        this.receiver = receiver;
    }

    InboundStream(int id, RemoteConnection remoteConnection, ByteInputResult byteInputResult) {
        this.id = id;
        this.remoteConnection = remoteConnection;
        NioByteInput byteInput = new NioByteInput((NioByteInput.InputHandler)new NioByteInputHandler());
        this.receiver = new NioByteInputReceiver(byteInput, remoteConnection);
        byteInputResult.accept(byteInput, this);
    }

    InboundStream(int id, RemoteConnection remoteConnection, OutputStream outputStream) {
        this.id = id;
        this.remoteConnection = remoteConnection;
        this.receiver = new OutputStreamReceiver(outputStream);
    }

    RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    Receiver getReceiver() {
        return this.receiver;
    }

    private void doSend(byte code) {
        ByteBuffer buffer = this.remoteConnection.allocate();
        buffer.position(4);
        buffer.put(code);
        buffer.putInt(this.id);
        buffer.flip();
        try {
            this.remoteConnection.sendBlocking(buffer, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendAsyncClose() {
        InboundStream inboundStream = this;
        synchronized (inboundStream) {
            block11: while (true) {
                switch (this.state) {
                    case WAITING_FIRST_EXCEPTION: {
                        return;
                    }
                    case WAITING_FIRST: {
                        try {
                            this.wait();
                            break;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            if (this.state != State.WAITING_FIRST) continue block11;
                            this.state = State.WAITING_FIRST_EXCEPTION;
                            this.notifyAll();
                            return;
                        }
                    }
                    case RUNNING: {
                        this.state = State.CLOSE_WAIT;
                        break block11;
                    }
                    case CLOSE_WAIT: {
                        this.state = State.CLOSED;
                        break block11;
                    }
                    case CLOSED: {
                        return;
                    }
                }
            }
            this.doSend((byte)36);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAsyncException() {
        InboundStream inboundStream = this;
        synchronized (inboundStream) {
            switch (this.state) {
                case RUNNING: {
                    this.state = State.CLOSE_WAIT;
                    break;
                }
                case CLOSE_WAIT: {
                    this.state = State.CLOSED;
                    break;
                }
                case CLOSED: {
                    return;
                }
            }
            this.doSend((byte)37);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAsyncStart() {
        InboundStream inboundStream = this;
        synchronized (inboundStream) {
            this.doSend((byte)38);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAck() {
        InboundStream inboundStream = this;
        synchronized (inboundStream) {
            switch (this.state) {
                case RUNNING: {
                    this.state = State.CLOSE_WAIT;
                    break;
                }
                case CLOSE_WAIT: {
                    this.state = State.CLOSED;
                    break;
                }
                case CLOSED: {
                    return;
                }
            }
            this.doSend((byte)37);
        }
    }

    static interface ByteInputResult {
        public void accept(NioByteInput var1, InboundStream var2);
    }

    private class OutputStreamReceiver
    implements Receiver {
        private final OutputStream outputStream;

        OutputStreamReceiver(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void push(ByteBuffer buffer) {
            try {
                if (buffer.hasArray()) {
                    byte[] array = buffer.array();
                    int offs = buffer.arrayOffset() + buffer.position();
                    int len = buffer.remaining();
                    this.outputStream.write(array, offs, len);
                } else {
                    byte[] array = new byte[buffer.remaining()];
                    buffer.get(array);
                    this.outputStream.write(array);
                }
            }
            catch (IOException e) {
                log.trace("Output stream write failed: %s", (Object)e);
                InboundStream.this.sendAsyncException();
            }
        }

        public void pushEof() {
            IoUtils.safeClose((Closeable)this.outputStream);
        }

        public void pushException() {
            IoUtils.safeClose((Closeable)this.outputStream);
        }
    }

    private static final class NioByteInputReceiver
    implements Receiver,
    NioByteInput.BufferReturn {
        private final NioByteInput nioByteInput;
        private final RemoteConnection remoteConnection;

        NioByteInputReceiver(NioByteInput nioByteInput, RemoteConnection remoteConnection) {
            this.nioByteInput = nioByteInput;
            this.remoteConnection = remoteConnection;
        }

        public void push(ByteBuffer buffer) {
            this.nioByteInput.push(buffer, (NioByteInput.BufferReturn)this);
        }

        public void pushEof() {
            this.nioByteInput.pushEof();
        }

        public void pushException() {
            this.nioByteInput.pushException(new IOException("Remote stream exception occurred on forwarded stream"));
        }

        public void returnBuffer(ByteBuffer buffer) {
            this.remoteConnection.free(buffer);
        }
    }

    private final class NioByteInputHandler
    implements NioByteInput.InputHandler {
        private NioByteInputHandler() {
        }

        public void acknowledge() {
            InboundStream.this.sendAck();
        }

        public void close() throws IOException {
            InboundStream.this.sendAsyncClose();
        }
    }

    static interface Receiver {
        public void push(ByteBuffer var1);

        public void pushEof();

        public void pushException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WAITING_FIRST,
        WAITING_FIRST_EXCEPTION,
        RUNNING,
        CLOSE_WAIT,
        CLOSED;

    }
}

