/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.remoting3.remote.ClientGreetingHandler;
import org.jboss.remoting3.remote.GreetingUtils;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Result;
import org.jboss.xnio.channels.ConnectedStreamChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientOpenListener
implements ChannelListener<ConnectedStreamChannel<InetSocketAddress>> {
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final Result<ConnectionHandlerFactory> factoryResult;
    private final CallbackHandler callbackHandler;
    private final ProviderDescriptor providerDescriptor;
    private final AccessControlContext accessControlContext;
    private static final Logger log = Loggers.client;

    ClientOpenListener(OptionMap optionMap, ConnectionProviderContext connectionProviderContext, Result<ConnectionHandlerFactory> factoryResult, CallbackHandler callbackHandler, ProviderDescriptor providerDescriptor, AccessControlContext accessControlContext) {
        this.optionMap = optionMap;
        this.connectionProviderContext = connectionProviderContext;
        this.factoryResult = factoryResult;
        this.callbackHandler = callbackHandler;
        this.providerDescriptor = providerDescriptor;
        this.accessControlContext = accessControlContext;
    }

    public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
        int[] versions;
        try {
            channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
        }
        catch (IOException e) {
            // empty catch block
        }
        final RemoteConnection connection = new RemoteConnection(this.connectionProviderContext.getExecutor(), channel, this.optionMap, this.providerDescriptor);
        final ByteBuffer buffer = connection.allocate();
        buffer.putInt(0);
        buffer.put((byte)0);
        for (int version : versions = this.providerDescriptor.getSupportedVersions()) {
            GreetingUtils.writeInt(buffer, (byte)3, version);
        }
        GreetingUtils.writeByte(buffer, (byte)0, (byte)0);
        buffer.flip();
        buffer.putInt(0, buffer.remaining() - 4);
        channel.getWriteSetter().set((ChannelListener)new ChannelListener<ConnectedStreamChannel<InetSocketAddress>>(){

            public void handleEvent(ConnectedStreamChannel<InetSocketAddress> channel) {
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = channel.write(buffer);
                    }
                    catch (IOException e1) {
                        log.trace((Throwable)e1, "Failed to send client greeting message", new Object[0]);
                        ClientOpenListener.this.factoryResult.setException(e1);
                        IoUtils.safeClose((Closeable)connection);
                        connection.free(buffer);
                        return;
                    }
                    if (res != 0) continue;
                    channel.resumeWrites();
                    return;
                }
                connection.free(buffer);
                try {
                    while (!channel.flush()) {
                    }
                }
                catch (IOException e) {
                    log.trace((Throwable)e, "Failed to flush client greeting message", new Object[0]);
                    ClientOpenListener.this.factoryResult.setException(e);
                    IoUtils.safeClose((Closeable)connection);
                    return;
                }
                log.trace("Client sent greeting message");
                channel.resumeReads();
            }
        });
        connection.setMessageHandler(new ClientGreetingHandler(connection, this.factoryResult, this.callbackHandler, this.accessControlContext));
        channel.resumeWrites();
    }
}

