/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class NameHandler
extends AbstractHandler {
    public static final String TAG_NAME = "name";
    private HandlerMaker maker = null;

    protected NameHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String langCode = element.getAttribute("xml:lang");
        String nameValue = XMLUtils.getText(element);
        Name obj = null;
        if (nameValue != null && nameValue.trim().length() > 0) {
            obj = new Name(nameValue, langCode);
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String nameValue;
        Name name = (Name)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        String langCode = name.getLanguageCode();
        if (langCode != null && langCode.trim().length() > 0) {
            element.setAttribute("xml:lang", langCode);
        }
        if ((nameValue = name.getValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(nameValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

