/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DispositionReportHandler
extends AbstractHandler {
    public static final String TAG_NAME = "dispositionReport";
    private HandlerMaker maker = null;

    protected DispositionReportHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        DispositionReport obj = new DispositionReport();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "result");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("result");
            obj.addResult((Result)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        String operator;
        DispositionReport report = (DispositionReport)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = report.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        }
        if ((operator = report.getOperator()) != null) {
            element.setAttribute("operator", operator);
        }
        if ((vector = report.getResultVector()) != null) {
            handler = this.maker.lookup("result");
            for (int i = 0; i < vector.size(); ++i) {
                Result result = (Result)vector.elementAt(i);
                handler.marshal(result, element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        ErrInfo errInfo = new ErrInfo();
        errInfo.setErrCode("E_accountLimitExceeded");
        errInfo.setErrMsg("Authentication token information has timed out.");
        Result result = new Result();
        result.setErrno(10160);
        result.setErrInfo(errInfo);
        ErrInfo errInfo2 = new ErrInfo();
        errInfo2.setErrCode("E_success");
        errInfo2.setErrMsg(null);
        Result result2 = new Result();
        result2.setErrno(0);
        result2.setErrInfo(errInfo2);
        DispositionReport report = new DispositionReport();
        report.setGeneric("2.0");
        report.setOperator("jUDDI.org");
        report.addResult(result);
        report.addResult(result2);
        System.out.println();
        RegistryObject regObject = report;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

