/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.mejb;

import java.rmi.RemoteException;
import java.util.Random;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.management.mejb.MEJB;

public abstract class ClientNotificationListener {
    private ObjectName mSender;
    private ObjectName mRemoteListener;
    protected NotificationListener mClientListener;
    protected Object mHandback;
    private Random mRandom = new Random();
    protected Logger log = Logger.getLogger(this.getClass());

    public ClientNotificationListener(ObjectName pSender, NotificationListener pClientListener, Object pHandback) {
        this.mSender = pSender;
        this.mClientListener = pClientListener;
        this.mHandback = pHandback;
    }

    public ObjectName createListener(MEJB pConnector, String pClass, Object[] pParameters, String[] pSignatures) throws MalformedObjectNameException, ReflectionException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        ObjectName lName = null;
        while (lName == null) {
            try {
                lName = new ObjectName("JMX:type=listener,id=" + this.mRandom.nextLong());
                ObjectInstance lInstance = pConnector.createMBean(pClass, lName, pParameters, pSignatures);
                lName = lInstance.getObjectName();
            }
            catch (InstanceAlreadyExistsException iaee) {
                lName = null;
            }
        }
        this.mRemoteListener = lName;
        return lName;
    }

    public void addNotificationListener(MEJB pConnector, NotificationFilter pFilter) throws InstanceNotFoundException, RemoteException {
        pConnector.addNotificationListener(this.mSender, this.mRemoteListener, pFilter, null);
    }

    public void removeNotificationListener(MEJB pConnector) throws InstanceNotFoundException, RemoteException {
        try {
            pConnector.removeNotificationListener(this.mSender, this.mRemoteListener);
        }
        catch (JMException jme) {
            // empty catch block
        }
        try {
            pConnector.unregisterMBean(this.mRemoteListener);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public ObjectName getSenderMBean() {
        return this.mSender;
    }

    public ObjectName getRemoteListenerName() {
        return this.mRemoteListener;
    }

    public boolean equals(Object pTest) {
        if (pTest instanceof ClientNotificationListener) {
            ClientNotificationListener lListener = (ClientNotificationListener)pTest;
            return this.mSender.equals(lListener.mSender) && this.mClientListener.equals(lListener.mClientListener);
        }
        return false;
    }
}

