/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.CRC32;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualJarInputStream;

public class VirtualJarFileInputStream
extends InputStream {
    private static final int MINIMUM_BUFFER_LENGTH = 1024;
    private final VirtualJarInputStream virtualJarInputStream;
    private State currentState = State.NOT_STARTED;
    private final List<ProcessedEntry> processedEntries = new LinkedList<ProcessedEntry>();
    private ProcessedEntry currentEntry;
    private final ByteBuffer buffer;
    private final CRC32 crc = new CRC32();
    private int currentCentralEntryIdx;
    private long centralOffset;
    private long totalRead;

    public VirtualJarFileInputStream(VirtualJarInputStream virtualJarInputStream) {
        this(virtualJarInputStream, 1024);
    }

    public VirtualJarFileInputStream(VirtualJarInputStream virtualJarInputStream, int bufferLength) {
        if (virtualJarInputStream == null) {
            throw new IllegalArgumentException("virtualJarInputStream is required");
        }
        if (bufferLength < 1024) {
            throw new IllegalArgumentException("The totalBufferLength must be larger than 1024");
        }
        this.virtualJarInputStream = virtualJarInputStream;
        this.buffer = new ByteBuffer(bufferLength);
    }

    @Override
    public int read() throws IOException {
        int readByte = -1;
        while (this.currentState != null && (readByte = this.currentState.read(this)) == -1) {
            this.currentState = this.currentState.getNextState(this);
        }
        ++this.totalRead;
        return readByte;
    }

    @Override
    public void close() throws IOException {
        VFSUtils.safeClose((Closeable)this.virtualJarInputStream);
        super.close();
    }

    private void closeCurrent() throws IOException {
        this.virtualJarInputStream.closeEntry();
        this.currentEntry.crc = this.crc.getValue();
        this.crc.reset();
    }

    private boolean bufferLocalFileHeader() throws IOException {
        this.buffer.reset();
        JarEntry jarEntry = this.virtualJarInputStream.getNextJarEntry();
        if (jarEntry == null) {
            return false;
        }
        this.currentEntry = new ProcessedEntry(jarEntry, this.totalRead);
        this.processedEntries.add(this.currentEntry);
        this.bufferInt(67324752L);
        this.bufferShort(10);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferInt(jarEntry.getTime());
        this.bufferInt(0L);
        this.bufferInt(0L);
        this.bufferInt(0L);
        byte[] nameBytes = jarEntry.getName().getBytes("UTF8");
        this.bufferShort(nameBytes.length);
        this.bufferShort(0);
        this.buffer(nameBytes);
        return true;
    }

    private boolean bufferNextCentralFileHeader() throws IOException {
        this.buffer.reset();
        if (this.currentCentralEntryIdx == this.processedEntries.size()) {
            return false;
        }
        ProcessedEntry entry = this.processedEntries.get(this.currentCentralEntryIdx++);
        JarEntry jarEntry = entry.jarEntry;
        this.bufferInt(33639248L);
        this.bufferShort(10);
        this.bufferShort(10);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferInt(jarEntry.getTime());
        this.bufferInt(entry.crc);
        this.bufferInt(jarEntry.getSize());
        this.bufferInt(jarEntry.getSize());
        byte[] nameBytes = jarEntry.getName().getBytes("UTF8");
        this.bufferShort(nameBytes.length);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferInt(0L);
        this.bufferInt(entry.offset);
        this.buffer(nameBytes);
        return true;
    }

    private void bufferCentralDirectoryEnd() throws IOException {
        this.buffer.reset();
        long lengthOfCentral = this.totalRead - this.centralOffset;
        int count = this.processedEntries.size();
        this.bufferInt(101010256L);
        this.bufferShort(0);
        this.bufferShort(0);
        this.bufferShort(count);
        this.bufferShort(count);
        this.bufferInt(lengthOfCentral);
        this.bufferInt(this.centralOffset);
        this.bufferShort(0);
    }

    private void bufferInt(long i) {
        this.buffer((byte)(i & 0xFFL));
        this.buffer((byte)(i >>> 8 & 0xFFL));
        this.buffer((byte)(i >>> 16 & 0xFFL));
        this.buffer((byte)(i >>> 24 & 0xFFL));
    }

    private void bufferShort(int i) {
        this.buffer((byte)(i & 0xFF));
        this.buffer((byte)(i >>> 8 & 0xFF));
    }

    private void buffer(byte b) {
        if (!this.buffer.hasCapacity()) {
            throw new IllegalStateException("Buffer does not have enough capacity");
        }
        this.buffer.put(b);
    }

    private void buffer(byte[] bytes) {
        for (byte b : bytes) {
            this.buffer(b);
        }
    }

    private static class ByteBuffer {
        private final int bufferLength;
        private final byte[] buffer;
        private int bufferPosition;
        private int bufferDepth;

        private ByteBuffer(int bufferLength) {
            this.buffer = new byte[bufferLength];
            this.bufferLength = bufferLength;
        }

        private boolean hasRemaining() {
            return this.bufferPosition < this.bufferDepth;
        }

        private boolean hasCapacity() {
            return this.bufferDepth < this.bufferLength;
        }

        private byte get() {
            return this.buffer[this.bufferPosition++];
        }

        private void put(byte b) {
            this.buffer[this.bufferDepth++] = b;
        }

        private void reset() {
            this.bufferPosition = 0;
            this.bufferDepth = 0;
        }
    }

    private static enum State {
        NOT_STARTED{

            @Override
            State transition(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                return LOCAL_ENTRY_HEADER;
            }
        }
        ,
        LOCAL_ENTRY_HEADER{
            boolean buffered;

            @Override
            void init(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                this.buffered = jarFileInputStream.bufferLocalFileHeader();
            }

            @Override
            int read(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (this.buffered && buffer.hasRemaining()) {
                    return buffer.get();
                }
                return -1;
            }

            @Override
            State transition(VirtualJarFileInputStream virtualJarFileInputStream) throws IOException {
                if (this.buffered) {
                    return ENTRY_CONTENT;
                }
                return START_CENTRAL_DIRECTORY;
            }
        }
        ,
        ENTRY_CONTENT{

            @Override
            int read(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                VirtualJarInputStream virtualJarInputStream = jarFileInputStream.virtualJarInputStream;
                return virtualJarInputStream.read();
            }

            @Override
            State transition(VirtualJarFileInputStream virtualJarFileInputStream) throws IOException {
                virtualJarFileInputStream.closeCurrent();
                return LOCAL_ENTRY_HEADER;
            }
        }
        ,
        START_CENTRAL_DIRECTORY{

            @Override
            void init(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                jarFileInputStream.centralOffset = jarFileInputStream.totalRead;
            }

            @Override
            State transition(VirtualJarFileInputStream virtualJarFileInputStream) throws IOException {
                return CENTRAL_ENTRY_HEADER;
            }
        }
        ,
        CENTRAL_ENTRY_HEADER{
            boolean buffered;

            @Override
            void init(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                this.buffered = jarFileInputStream.bufferNextCentralFileHeader();
            }

            @Override
            int read(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (this.buffered && buffer.hasRemaining()) {
                    return buffer.get();
                }
                return -1;
            }

            @Override
            State transition(VirtualJarFileInputStream virtualJarFileInputStream) throws IOException {
                if (this.buffered) {
                    return CENTRAL_ENTRY_HEADER;
                }
                return CENTRAL_END;
            }
        }
        ,
        CENTRAL_END{

            @Override
            void init(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                jarFileInputStream.bufferCentralDirectoryEnd();
            }

            @Override
            int read(VirtualJarFileInputStream jarFileInputStream) throws IOException {
                ByteBuffer buffer = jarFileInputStream.buffer;
                if (buffer.hasRemaining()) {
                    return buffer.get();
                }
                return -1;
            }

            @Override
            State transition(VirtualJarFileInputStream virtualJarFileInputStream) throws IOException {
                return null;
            }
        };


        void init(VirtualJarFileInputStream jarFileInputStream) throws IOException {
        }

        abstract State transition(VirtualJarFileInputStream var1) throws IOException;

        int read(VirtualJarFileInputStream jarFileInputStream) throws IOException {
            return -1;
        }

        State getNextState(VirtualJarFileInputStream jarFileInputStream) throws IOException {
            State nextState = this.transition(jarFileInputStream);
            if (nextState != null) {
                nextState.init(jarFileInputStream);
            }
            return nextState;
        }
    }

    private class ProcessedEntry {
        private final JarEntry jarEntry;
        private final long offset;
        private long crc;

        private ProcessedEntry(JarEntry jarEntry, long offset) {
            this.jarEntry = jarEntry;
            this.offset = offset;
        }
    }
}

