/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UITree;
import org.richfaces.model.LastElementAware;
import org.richfaces.model.TreeRowKey;

public abstract class TreeDataModelEventNavigator
implements LastElementAware {
    private TreeRowKey floatingKey;
    protected boolean lastElement = false;
    protected boolean actualLast = false;
    protected Boolean stackedLast = null;
    private TreeRowKey rowKey;
    private UITree tree;

    public TreeDataModelEventNavigator(UITree tree, TreeRowKey floatingKey) {
        this.tree = tree;
        this.rowKey = floatingKey;
        this.floatingKey = floatingKey;
    }

    public void followRowKey(FacesContext context, TreeRowKey newRowKey) throws IOException {
        this.actualLast = this.lastElement;
        this.resetLastElement();
        if (newRowKey != null) {
            int level = this.rowKey != null ? this.rowKey.depth() : 0;
            int delta = level - newRowKey.depth();
            if (delta > 0) {
                this.beforeUp(delta);
            } else if (delta < 0) {
                if (delta == -1) {
                    this.beforeDown();
                } else {
                    throw new IllegalArgumentException("One or more nodes skipped in falldown - maybe illegal RowKey, incorrect model or model handler!");
                }
            }
            this.stackedLast = new Boolean(this.actualLast);
            this.tree.setRowKey(context, newRowKey);
            if (delta > 0) {
                this.afterUp(delta);
            } else if (delta == -1) {
                this.afterDown();
            }
        } else {
            this.stackedLast = null;
            int level = 0;
            if (this.rowKey != null) {
                level = this.rowKey.depth();
                if (this.floatingKey != null) {
                    level -= this.floatingKey.depth();
                }
                this.beforeUp(level);
            } else {
                this.beforeDown();
                this.afterDown();
                this.beforeUp(1);
                this.afterUp(1);
            }
            this.tree.setRowKey(context, null);
            this.afterUp(level);
        }
        this.rowKey = newRowKey;
    }

    public abstract void beforeUp(int var1) throws IOException;

    public abstract void beforeDown() throws IOException;

    public abstract void afterUp(int var1) throws IOException;

    public abstract void afterDown() throws IOException;

    public void setLastElement() {
        this.lastElement = true;
    }

    public void resetLastElement() {
        this.lastElement = false;
    }

    protected TreeRowKey getRowKey() {
        return this.rowKey;
    }

    protected TreeRowKey getFloatingKey() {
        return this.floatingKey;
    }

    protected boolean isStackedLastElement() {
        if (this.stackedLast != null) {
            return this.stackedLast;
        }
        return false;
    }
}

