/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class NakReceiverWindowTest2 {
    static final int NUM_THREADS = 200;
    static final int NUM_MSGS = 5000;
    static final short NAKACK_ID = 100;
    final Address self = Util.createRandomAddress();
    final Address sender = Util.createRandomAddress();
    final CyclicBarrier barrier = new CyclicBarrier(201);
    NakReceiverWindow win;

    @BeforeMethod
    void init() {
        this.win = new NakReceiverWindow(this.self, new Retransmitter.RetransmitCommand(){

            @Override
            public void retransmit(long first_seqno, long last_seqno, Address sender) {
            }
        }, 0L, 0L, new DefaultTimeScheduler(2));
    }

    @AfterMethod
    void cleanup() {
        this.win.destroy();
    }

    @Test(invocationCount=10)
    public void testConcurrentInsertions() throws BrokenBarrierException, InterruptedException {
        AtomicInteger val;
        int i;
        int i2;
        Sender[] senders = new Sender[200];
        ConcurrentHashMap<Long, AtomicInteger> successful_adds = new ConcurrentHashMap<Long, AtomicInteger>();
        for (i2 = 1; i2 <= 5000; ++i2) {
            successful_adds.put(Long.valueOf(i2), new AtomicInteger(0));
        }
        for (i2 = 0; i2 < senders.length; ++i2) {
            senders[i2] = new Sender(5000, this.win, this.sender, this.barrier, successful_adds);
            senders[i2].start();
        }
        Util.sleep(2000L);
        System.out.println("Concurrently inserting 5000 messages with 200 threads");
        this.barrier.await();
        for (i2 = 0; i2 < senders.length; ++i2) {
            senders[i2].join(20000L);
        }
        System.out.println("OK: 5000 were added to the NakReceiverWindow concurrently by 200 threads");
        Set keys = successful_adds.keySet();
        System.out.println("checking for missing or duplicate seqnos in " + keys.size() + " seqnos:");
        for (i = 1; i <= 5000; ++i) {
            val = (AtomicInteger)successful_adds.get(i);
            if (val.get() == 1) continue;
            System.err.println(i + " was not added exactly once (successful insertions=" + val.get() + ")");
        }
        for (i = 1; i <= 5000; ++i) {
            val = (AtomicInteger)successful_adds.get(i);
            assert (val != null) : i + " is missing in " + successful_adds.keySet();
            assert (val.get() == 1) : i + " was not added exactly once (successful insertions=" + val.get() + ")";
        }
        System.out.println("OK: " + keys.size() + " seqnos were added exactly once");
    }

    @Test(invocationCount=5)
    public void testConcurrentRandomInsertions() throws BrokenBarrierException, InterruptedException {
        AtomicInteger val;
        int i;
        int i2;
        RandomSender[] senders = new RandomSender[200];
        ConcurrentHashMap<Long, AtomicInteger> successful_adds = new ConcurrentHashMap<Long, AtomicInteger>();
        for (i2 = 1; i2 <= 5000; ++i2) {
            successful_adds.put(Long.valueOf(i2), new AtomicInteger(0));
        }
        for (i2 = 0; i2 < senders.length; ++i2) {
            senders[i2] = new RandomSender(5000, this.win, this.sender, this.barrier, successful_adds);
            senders[i2].start();
        }
        Util.sleep(2000L);
        System.out.println("Concurrently inserting 5000 messages with 200 threads");
        this.barrier.await();
        for (i2 = 0; i2 < senders.length; ++i2) {
            senders[i2].join(20000L);
        }
        System.out.println("OK: 5000 were added to the NakReceiverWindow concurrently by 200 threads");
        Set keys = successful_adds.keySet();
        System.out.println("checking for missing or duplicate seqnos in " + keys.size() + " seqnos:");
        for (i = 1; i <= 5000; ++i) {
            val = (AtomicInteger)successful_adds.get(i);
            if (val.get() == 1) continue;
            System.err.println(i + " was not added exactly once (successful insertions=" + val.get() + ")");
        }
        for (i = 1; i <= 5000; ++i) {
            val = (AtomicInteger)successful_adds.get(i);
            assert (val != null) : i + " is missing in " + successful_adds.keySet();
            assert (val.get() == 1) : i + " was not added exactly once (successful insertions=" + val.get() + ")";
        }
        System.out.println("OK: " + keys.size() + " seqnos were added exactly once");
    }

    @Test(invocationCount=5)
    public void testConcurrentInsertionOfSameSeqno() throws BrokenBarrierException, InterruptedException {
        int i;
        SameSeqnoSender[] senders = new SameSeqnoSender[200];
        ConcurrentHashMap<Long, AtomicInteger> successful_adds = new ConcurrentHashMap<Long, AtomicInteger>();
        for (i = 1; i <= 5000; ++i) {
            successful_adds.put(Long.valueOf(i), new AtomicInteger(0));
        }
        for (i = 0; i < senders.length; ++i) {
            senders[i] = new SameSeqnoSender(5000, this.win, this.sender, this.barrier, successful_adds);
            senders[i].start();
        }
        Util.sleep(2000L);
        System.out.println("Concurrently inserting 1 message with 200 threads");
        this.barrier.await();
        for (i = 0; i < senders.length; ++i) {
            senders[i].join(20000L);
        }
        System.out.println("OK: 1 message was added to the NakReceiverWindow concurrently by 200 threads");
        Set keys = successful_adds.keySet();
        System.out.println("checking for missing or duplicate seqnos in " + keys.size() + " seqnos:");
        AtomicInteger val = (AtomicInteger)successful_adds.get(1L);
        if (val.get() != 1) {
            System.err.println("1 was not added exactly once (successful insertions=" + val.get() + ")");
        }
        assert (val.get() == 1) : "1 was not added exactly once (successful insertions=" + val.get() + ")";
        System.out.println("OK: 1 seqno was added exactly once");
    }

    static class SameSeqnoSender
    extends Sender {
        public SameSeqnoSender(int num, NakReceiverWindow win, Address sender, CyclicBarrier barrier, ConcurrentMap<Long, AtomicInteger> map) {
            super(num, win, sender, barrier, map);
        }

        @Override
        public void run() {
            this.waitForBarrier();
            for (int i = 1; i <= this.num; ++i) {
                this.add(1L);
            }
        }
    }

    static class RandomSender
    extends Sender {
        public RandomSender(int num, NakReceiverWindow win, Address sender, CyclicBarrier barrier, ConcurrentMap<Long, AtomicInteger> map) {
            super(num, win, sender, barrier, map);
        }

        @Override
        public void run() {
            ArrayList<Long> seqnos = new ArrayList<Long>(this.num);
            for (long i = 1L; i <= (long)this.num; ++i) {
                seqnos.add(i);
            }
            Collections.shuffle(seqnos);
            this.waitForBarrier();
            Iterator i$ = seqnos.iterator();
            while (i$.hasNext()) {
                long seqno = (Long)i$.next();
                this.add(seqno);
            }
        }
    }

    static class Sender
    extends Thread {
        final int num;
        final NakReceiverWindow win;
        final Address sender;
        final CyclicBarrier barrier;
        final ConcurrentMap<Long, AtomicInteger> map;

        public Sender(int num, NakReceiverWindow win, Address sender, CyclicBarrier barrier, ConcurrentMap<Long, AtomicInteger> map) {
            this.num = num;
            this.win = win;
            this.sender = sender;
            this.barrier = barrier;
            this.map = map;
        }

        @Override
        public void run() {
            this.waitForBarrier();
            for (int i = 1; i <= this.num; ++i) {
                this.add(i);
            }
        }

        protected void add(long seqno) {
            NakAckHeader hdr = NakAckHeader.createMessageHeader(seqno);
            Message msg = new Message(null, this.sender, (Serializable)((Object)"hello"));
            msg.putHeader((short)100, hdr);
            boolean added = this.win.add(seqno, msg);
            if (added) {
                AtomicInteger val = (AtomicInteger)this.map.get(seqno);
                val.incrementAndGet();
            }
        }

        protected void waitForBarrier() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

