/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.jgroups.Address;
import org.jgroups.util.CreditMap;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class CreditMapTest {
    static Address a = Util.createRandomAddress("A");
    static Address b = Util.createRandomAddress("B");
    static Address c = Util.createRandomAddress("C");
    static Address d = Util.createRandomAddress("D");
    static long MAX_CREDITS = 1000L;
    protected CreditMap map;

    @BeforeMethod
    void create() {
        this.map = new CreditMap(MAX_CREDITS);
    }

    @AfterMethod
    void destroy() {
        this.map.clear();
    }

    private void addAll() {
        this.map.putIfAbsent(a);
        this.map.putIfAbsent(b);
        this.map.putIfAbsent(c);
        this.map.putIfAbsent(d);
    }

    private void replenishAll(long credits) {
        this.map.replenish(a, credits);
        this.map.replenish(b, credits);
        this.map.replenish(c, credits);
        this.map.replenish(d, credits);
    }

    public void testSimpleDecrement() {
        this.addAll();
        System.out.println("map:\n" + this.map);
        boolean rc = this.map.decrement(200L, 4000L);
        System.out.println("rc=" + rc + ", map:\n" + this.map);
        assert (rc);
        assert (this.map.getMinCredits() == MAX_CREDITS - 200L);
        assert (this.map.getAccumulatedCredits() == 200L);
        rc = this.map.decrement(150L, 100L);
        System.out.println("\nrc=" + rc + ", map:\n" + this.map);
        assert (rc);
        assert (this.map.getMinCredits() == MAX_CREDITS - 200L - 150L);
        assert (this.map.getAccumulatedCredits() == 350L);
        rc = this.map.decrement(300L, 100L);
        System.out.println("\nrc=" + rc + ", map:\n" + this.map);
        assert (rc);
        assert (this.map.getMinCredits() == MAX_CREDITS - 200L - 150L - 300L);
        assert (this.map.getAccumulatedCredits() == 650L);
        rc = this.map.decrement(500L, 100L);
        System.out.println("\nrc=" + rc + ", map:\n" + this.map);
        assert (!rc);
        assert (this.map.getMinCredits() == MAX_CREDITS - 200L - 150L - 300L);
        assert (this.map.getAccumulatedCredits() == 650L);
    }

    public void testDecrementAndReplenish() {
        this.testSimpleDecrement();
        this.map.replenish(a, MAX_CREDITS);
        System.out.println("\nmap:\n" + this.map);
        assert (this.map.getMinCredits() == MAX_CREDITS - 200L - 150L - 300L);
        assert (this.map.getAccumulatedCredits() == 0L);
        this.map.replenish(b, MAX_CREDITS);
        this.map.replenish(c, MAX_CREDITS);
        System.out.println("\nmap:\n" + this.map);
        assert (this.map.getMinCredits() == MAX_CREDITS - 200L - 150L - 300L);
        assert (this.map.getAccumulatedCredits() == 0L);
        this.map.replenish(d, MAX_CREDITS);
        System.out.println("\nmap:\n" + this.map);
        assert (this.map.getMinCredits() == MAX_CREDITS);
        assert (this.map.getAccumulatedCredits() == 0L);
    }

    public void testDecrementAndReplenish2() {
        this.map.putIfAbsent(a);
        this.map.decrement(200L, 100L);
        this.map.putIfAbsent(b);
        this.map.decrement(200L, 100L);
        this.map.putIfAbsent(c);
        this.map.decrement(200L, 100L);
        this.map.putIfAbsent(d);
        this.map.decrement(200L, 100L);
        System.out.println("map = " + this.map);
        assert (this.map.getAccumulatedCredits() == 200L);
        assert (this.map.getMinCredits() == 200L);
        this.map.replenish(d, 100L);
        this.map.replenish(c, 100L);
        this.map.replenish(a, 100L);
        this.map.replenish(b, 100L);
        assert (this.map.getMinCredits() == 300L);
    }

    public void testBlockingDecrementAndReplenishment() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    Util.sleep(1000L);
                    CreditMapTest.this.replenishAll(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        this.addAll();
        boolean rc = this.map.decrement(800L, 100L);
        assert (rc);
        System.out.println("map:\n" + this.map);
        barrier.await();
        rc = this.map.decrement(250L, 5000L);
        assert (rc);
        System.out.println("map:\n" + this.map);
        assert (this.map.getMinCredits() == 50L);
        assert (this.map.getAccumulatedCredits() == 250L);
    }

    public void testBlockingDecrementAndReplenishment2() {
        long[] credit_sizes = new long[]{500L, 100L, 100L, 500L, 300L};
        Thread[] decrementers = new Decrementer[credit_sizes.length];
        this.addAll();
        boolean rc = this.map.decrement(800L, 100L);
        assert (rc);
        for (int i = 0; i < credit_sizes.length; ++i) {
            decrementers[i] = new Decrementer(this.map, credit_sizes[i], 20000L, true);
        }
        for (Decrementer decrementer : decrementers) {
            decrementer.start();
        }
        Util.sleep(1000L);
        int alive = this.countAliveThreads(decrementers);
        assert (alive == 3);
        this.replenishAll(400L);
        Util.sleep(500L);
        alive = this.countAliveThreads(decrementers);
        assert (alive == 2);
        this.replenishAll(700L);
        Util.sleep(500L);
        alive = this.countAliveThreads(decrementers);
        assert (alive == 1);
        this.replenishAll(300L);
        Util.sleep(500L);
        alive = this.countAliveThreads(decrementers);
        assert (alive == 0);
    }

    public void testClear() {
        this.addAll();
        boolean rc = this.map.decrement(800L, 100L);
        assert (rc);
        Decrementer decr1 = new Decrementer(this.map, 300L, 20000L, false);
        Decrementer decr2 = new Decrementer(this.map, 500L, 20000L, false);
        decr1.start();
        decr2.start();
        Util.sleep(500L);
        this.map.clear();
        for (int i = 0; i < 5 && (decr1.isAlive() || decr2.isAlive()); ++i) {
            Util.sleep(1000L);
        }
        assert (!decr1.isAlive());
        assert (!decr2.isAlive());
    }

    public void testGetMembersWithInsufficientCredits() {
        this.addAll();
        boolean rc = this.map.decrement(800L, 50L);
        assert (rc);
        List<Address> list = this.map.getMembersWithInsufficientCredits(100L);
        assert (list.isEmpty());
        list = this.map.getMembersWithInsufficientCredits(200L);
        assert (list.isEmpty());
        list = this.map.getMembersWithInsufficientCredits(250L);
        assert (list.size() == 4);
        assert (list.contains(a) && list.contains(b) && list.contains(c) && list.contains(d));
        this.map.remove(b);
        this.map.remove(c);
        list = this.map.getMembersWithInsufficientCredits(250L);
        assert (list.size() == 2);
        assert (list.contains(a) && list.contains(d));
        this.map.decrement(100L, 50L);
        this.map.putIfAbsent(b);
        this.map.putIfAbsent(c);
        list = this.map.getMembersWithInsufficientCredits(800L);
        assert (list.size() == 2);
        assert (list.contains(a) && list.contains(d));
        list = this.map.getMembersWithInsufficientCredits(100L);
        assert (list.isEmpty());
    }

    protected int countAliveThreads(Thread[] threads) {
        int alive = 0;
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            ++alive;
        }
        return alive;
    }

    protected static class Decrementer
    extends Thread {
        private final CreditMap map;
        private final long amount;
        private final long timeout;
        protected final boolean loop;

        public Decrementer(CreditMap map, long amount, long timeout, boolean loop) {
            this.map = map;
            this.amount = amount;
            this.timeout = timeout;
            this.loop = loop;
        }

        @Override
        public void run() {
            do {
                boolean rc;
                if (!(rc = this.map.decrement(this.amount, this.timeout))) continue;
                System.out.println("[" + this.getId() + "] decremented " + this.amount + " credits");
                break;
            } while (this.loop);
        }
    }
}

