/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class ENCRYPT
extends Protocol {
    Observer observer;
    private static final String DEFAULT_SYM_ALGO = "AES";
    Address local_addr = null;
    Address keyServerAddr = null;
    boolean keyServer = false;
    @Property(name="asym_provider", description="Cryptographic Service Provider. Default is Bouncy Castle Provider")
    String asymProvider = null;
    static final String symProvider = null;
    @Property(name="asym_algorithm", description="Cipher engine transformation for asymmetric algorithm. Default is RSA")
    String asymAlgorithm = "RSA";
    @Property(name="sym_algorithm", description="Cipher engine transformation for symmetric algorithm. Default is AES")
    String symAlgorithm = "AES";
    @Property(name="asym_init", description="Initial public/private key length. Default is 512")
    int asymInit = 512;
    @Property(name="sym_init", description="Initial key length for matching symmetric algorithm. Default is 128")
    int symInit = 128;
    private boolean suppliedKey = false;
    @Property(name="key_store_name", description="File on classpath that contains keystore repository")
    String keyStoreName;
    @Property(name="store_password", description="Password used to check the integrity/unlock the keystore. Change the default")
    private String storePassword = "changeit";
    @Property(name="key_password", description="Password for recovering the key. Change the default")
    private String keyPassword = "changeit";
    @Property(name="alias", description="Alias used for recovering the key. Change the default")
    private String alias = "mykey";
    KeyPair Kpair;
    PublicKey serverPubKey = null;
    Cipher symEncodingCipher;
    Cipher symDecodingCipher;
    protected final Lock decrypt_lock = new ReentrantLock();
    private String symVersion = null;
    SecretKey secretKey = null;
    final Map<String, Cipher> keyMap = new WeakHashMap<String, Cipher>();
    private boolean queue_up = true;
    private boolean queue_down = false;
    private BlockingQueue<Event> upMessageQueue = new LinkedBlockingQueue<Event>();
    private BlockingQueue<Event> downMessageQueue = new LinkedBlockingQueue<Event>();
    private Cipher asymCipher;
    @Property
    private boolean encrypt_entire_message = false;

    public void setObserver(Observer o) {
        this.observer = o;
    }

    private static String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }

    @Override
    public void init() throws Exception {
        if (this.keyPassword == null && this.storePassword != null) {
            this.keyPassword = this.storePassword;
            if (this.log.isInfoEnabled()) {
                this.log.info("key_password used is same as store_password");
            }
        }
        if (this.keyStoreName == null) {
            this.initSymKey();
            this.initKeyPair();
        } else {
            this.initConfiguredKey();
        }
        this.initSymCiphers(this.symAlgorithm, this.getSecretKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfiguredKey() throws Exception {
        InputStream inputStream = null;
        KeyStore store = KeyStore.getInstance("JCEKS");
        SecretKey tempKey = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keyStoreName);
            if (inputStream == null) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + " ensure file is on classpath");
            }
            try {
                store.load(inputStream, this.storePassword.toCharArray());
                tempKey = (SecretKey)store.getKey(this.alias, this.keyPassword.toCharArray());
            }
            catch (IOException e) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + ": " + e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception("No Such algorithm " + this.keyStoreName + ": " + e);
            }
            catch (CertificateException e) {
                throw new Exception("Certificate exception " + this.keyStoreName + ": " + e);
            }
            if (tempKey == null) {
                throw new Exception("Unable to retrieve key '" + this.alias + "' from keystore " + this.keyStoreName);
            }
            this.setSecretKey(tempKey);
            if (this.symAlgorithm.equals(DEFAULT_SYM_ALGO)) {
                this.symAlgorithm = tempKey.getAlgorithm();
            }
            this.suppliedKey = true;
            this.queue_down = false;
            this.queue_up = false;
        }
        catch (Throwable throwable) {
            Util.close(inputStream);
            throw throwable;
        }
        Util.close(inputStream);
    }

    public void initSymKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = symProvider != null && symProvider.trim().length() > 0 ? KeyGenerator.getInstance(ENCRYPT.getAlgorithm(this.symAlgorithm), symProvider) : KeyGenerator.getInstance(ENCRYPT.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.secretKey = keyGen.generateKey();
        this.setSecretKey(this.secretKey);
        if (this.log.isInfoEnabled()) {
            this.log.info(" Symmetric key generated ");
        }
    }

    private void initSymCiphers(String algorithm, SecretKey secret) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info(" Initializing symmetric ciphers");
        }
        this.symEncodingCipher = Cipher.getInstance(algorithm);
        this.symDecodingCipher = Cipher.getInstance(algorithm);
        this.symEncodingCipher.init(1, secret);
        this.symDecodingCipher.init(2, secret);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(secret.getEncoded());
        this.symVersion = new String(digest.digest(), "UTF-8");
        if (this.log.isInfoEnabled()) {
            this.log.info(" Initialized symmetric ciphers with secret key (" + this.symVersion.length() + " bytes)");
        }
    }

    public void initKeyPair() throws Exception {
        KeyPairGenerator KpairGen = null;
        KpairGen = this.asymProvider != null && this.asymProvider.trim().length() > 0 ? KeyPairGenerator.getInstance(ENCRYPT.getAlgorithm(this.asymAlgorithm), this.asymProvider) : KeyPairGenerator.getInstance(ENCRYPT.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        this.asymCipher = Cipher.getInstance(this.asymAlgorithm);
        this.asymCipher.init(2, this.Kpair.getPrivate());
        if (this.log.isInfoEnabled()) {
            this.log.info(" asym algo initialized");
        }
    }

    public void reset() {
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View view = (View)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info("handling view-change up: " + view);
                }
                if (this.suppliedKey) break;
                this.handleViewChange(view, false);
                break;
            }
            case 15: {
                View view = (View)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info("handling tmp-view up: " + view);
                }
                if (this.suppliedKey) break;
                this.handleViewChange(view, true);
                break;
            }
            case 1: {
                try {
                    this.handleUpMessage(evt);
                }
                catch (Exception e) {
                    this.log.warn("exception occurred decrypting message", e);
                }
                return null;
            }
        }
        return this.passItUp(evt);
    }

    public Object passItUp(Event evt) {
        if (this.observer != null) {
            this.observer.passUp(evt);
        }
        return this.up_prot != null ? this.up_prot.up(evt) : null;
    }

    private synchronized void handleViewChange(View view, boolean makeServer) {
        Vector<Address> members = view.getMembers();
        if (members == null || members.isEmpty() || members.get(0) == null) {
            this.becomeKeyServer(this.local_addr);
            return;
        }
        Address tmpKeyServer = view.getMembers().get(0);
        if (makeServer || tmpKeyServer.equals(this.local_addr) && (this.keyServerAddr == null || !tmpKeyServer.equals(this.keyServerAddr))) {
            this.becomeKeyServer(tmpKeyServer);
        } else if (this.keyServerAddr == null || !tmpKeyServer.equals(this.keyServerAddr)) {
            this.handleNewKeyServer(tmpKeyServer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Membership has changed but I do not care");
        }
    }

    private void becomeKeyServer(Address tmpKeyServer) {
        this.keyServerAddr = tmpKeyServer;
        this.keyServer = true;
        if (this.log.isInfoEnabled()) {
            this.log.info("I have become key server " + this.keyServerAddr);
        }
        this.queue_down = false;
        this.queue_up = false;
    }

    private void handleNewKeyServer(Address newKeyServer) {
        this.queue_up = true;
        this.queue_down = true;
        this.keyServerAddr = newKeyServer;
        this.keyServer = false;
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending key request");
        }
        this.sendKeyRequest();
    }

    private void handleUpMessage(Event evt) throws Exception {
        Message msg = (Message)evt.getArg();
        if (msg == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("null message - passing straight up");
            }
            this.passItUp(evt);
            return;
        }
        if (msg.getLength() == 0 && !this.encrypt_entire_message) {
            this.passItUp(evt);
            return;
        }
        EncryptHeader hdr = (EncryptHeader)msg.getHeader(this.id);
        if (hdr == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("dropping message as ENCRYPT header is null  or has not been recognized, msg will not be passed up, headers are " + msg.printHeaders());
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("header received " + hdr);
        }
        if (hdr.getType() == 0) {
            if (!hdr.encrypt_entire_msg && ((Message)evt.getArg()).getLength() == 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("passing up message as it has an empty buffer ");
                }
                this.passItUp(evt);
                return;
            }
            if (this.queue_up) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("queueing up message as no session key established: " + evt.getArg());
                }
                this.upMessageQueue.put(evt);
            } else {
                Message tmpMsg;
                if (!this.suppliedKey) {
                    this.drainUpQueue();
                }
                if ((tmpMsg = this.decryptMessage(this.symDecodingCipher, msg.copy())) != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("decrypted message " + tmpMsg);
                    }
                    this.passItUp(new Event(1, tmpMsg));
                } else {
                    this.log.warn("Unrecognised cipher discarding message");
                }
            }
        } else if (this.suppliedKey) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("We received an encrypt header of " + hdr.getType() + " while in configured mode");
            }
        } else {
            switch (hdr.getType()) {
                case 1: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("received a key request from peer");
                    }
                    try {
                        PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
                        this.sendSecretKey(this.getSecretKey(), tmpKey, msg.getSrc());
                    }
                    catch (Exception e) {
                        this.log.warn("unable to reconstitute peer's public key");
                    }
                    break;
                }
                case 3: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("received a secretkey response from keyserver");
                    }
                    try {
                        SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
                        if (tmp == null) {
                            this.sendKeyRequest();
                            break;
                        }
                        this.setKeys(tmp, hdr.getVersion());
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Decoded secretkey response");
                    }
                    catch (Exception e) {
                        this.log.warn("unable to process received public key");
                    }
                    break;
                }
                default: {
                    this.log.warn("Received ignored encrypt header of " + hdr.getType());
                }
            }
        }
    }

    private void drainUpQueue() throws Exception {
        Event tmp = null;
        while ((tmp = this.upMessageQueue.poll(0L, TimeUnit.MILLISECONDS)) != null) {
            Message msg = this.decryptMessage(this.symDecodingCipher, ((Message)tmp.getArg()).copy());
            if (msg != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("passing up message from drain " + msg);
                }
                this.passItUp(new Event(1, msg));
                continue;
            }
            this.log.warn("discarding message in queue up drain as cannot decode it");
        }
    }

    private void setKeys(SecretKey key, String version) throws Exception {
        this.keyMap.put(this.getSymVersion(), this.getSymDecodingCipher());
        this.setSecretKey(key);
        this.initSymCiphers(key.getAlgorithm(), key);
        this.setSymVersion(version);
        this.log.info("setting queue up to false in setKeys");
        this.queue_up = false;
        this.drainUpQueue();
        this.queue_down = false;
        this.drainDownQueue();
    }

    private Message decryptMessage(Cipher cipher, Message msg) throws Exception {
        EncryptHeader hdr = (EncryptHeader)msg.getHeader(this.id);
        if (!hdr.getVersion().equals(this.getSymVersion())) {
            this.log.warn("attempting to use stored cipher as message does not uses current encryption version ");
            cipher = this.keyMap.get(hdr.getVersion());
            if (cipher == null) {
                this.log.warn("Unable to find a matching cipher in previous key map");
                return null;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("decrypting using previous cipher version " + hdr.getVersion());
            }
            return this._decrypt(cipher, msg, hdr.encrypt_entire_msg);
        }
        return this._decrypt(cipher, msg, hdr.encrypt_entire_msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message _decrypt(Cipher cipher, Message msg, boolean decrypt_entire_msg) throws Exception {
        byte[] decrypted_msg;
        this.decrypt_lock.lock();
        try {
            decrypted_msg = cipher.doFinal(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
        }
        finally {
            this.decrypt_lock.unlock();
        }
        if (!decrypt_entire_msg) {
            msg.setBuffer(decrypted_msg);
            return msg;
        }
        Message ret = (Message)Util.streamableFromByteBuffer(Message.class, decrypted_msg);
        if (ret.getDest() == null) {
            ret.setDest(msg.getDest());
        }
        if (ret.getSrc() == null) {
            ret.setSrc(msg.getSrc());
        }
        return ret;
    }

    private void sendSecretKey(SecretKey secret, PublicKey pubKey, Address source) throws InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("encoding shared key ");
        }
        Cipher tmp = Cipher.getInstance(this.asymAlgorithm);
        tmp.init(1, pubKey);
        byte[] encryptedKey = tmp.doFinal(secret.getEncoded());
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Generated encoded key which only client can decode:" + ENCRYPT.formatArray(encryptedKey));
        }
        Message newMsg = new Message(source, this.local_addr, encryptedKey);
        newMsg.putHeader(this.id, new EncryptHeader(3, this.getSymVersion()));
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Sending version " + this.getSymVersion() + " encoded key to client");
        }
        this.passItDown(new Event(1, newMsg));
    }

    private Message sendKeyRequest() {
        Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
        newMsg.putHeader(this.id, new EncryptHeader(1, this.getSymVersion()));
        this.passItDown(new Event(1, newMsg));
        return newMsg;
    }

    @Override
    public Object down(Event evt) {
        if (this.observer != null) {
            this.observer.down(evt);
        }
        switch (evt.getType()) {
            case 1: {
                try {
                    if (this.queue_down) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("queueing down message as no session key established" + evt.getArg());
                        }
                        this.downMessageQueue.put(evt);
                    } else {
                        if (!this.suppliedKey) {
                            this.drainDownQueue();
                        }
                        this.sendDown(evt);
                    }
                }
                catch (Exception e) {
                    this.log.warn("unable to send down event " + e);
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info("handling view-change down: " + view);
                }
                if (this.suppliedKey) break;
                this.handleViewChange(view, false);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("set local address to " + this.local_addr);
                break;
            }
            case 15: {
                View view = (View)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info("handling tmp-view down: " + view);
                }
                if (this.suppliedKey) break;
                this.handleViewChange(view, true);
                break;
            }
        }
        return this.down_prot.down(evt);
    }

    public Object passItDown(Event evt) {
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        return this.down_prot != null ? this.down_prot.down(evt) : null;
    }

    private void drainDownQueue() throws Exception {
        Event tmp = null;
        while ((tmp = this.downMessageQueue.poll(0L, TimeUnit.MILLISECONDS)) != null) {
            this.sendDown(tmp);
        }
    }

    private void sendDown(Event evt) throws Exception {
        if (evt.getType() != 1) {
            return;
        }
        Message msg = (Message)evt.getArg();
        if (msg.getLength() == 0 && !this.encrypt_entire_message) {
            this.passItDown(evt);
            return;
        }
        EncryptHeader hdr = new EncryptHeader(0, this.getSymVersion());
        hdr.encrypt_entire_msg = this.encrypt_entire_message;
        if (this.encrypt_entire_message) {
            byte[] serialized_msg = Util.streamableToByteBuffer(msg);
            byte[] encrypted_msg = this.encryptMessage(this.symEncodingCipher, serialized_msg, 0, serialized_msg.length);
            Message tmp = msg.copy(false);
            tmp.setBuffer(encrypted_msg);
            tmp.setSrc(this.local_addr);
            tmp.putHeader(this.id, hdr);
            this.passItDown(new Event(1, tmp));
            return;
        }
        msg.putHeader(this.id, hdr);
        Message msgEncrypted = msg.copy(false);
        msgEncrypted.setBuffer(this.encryptMessage(this.symEncodingCipher, msg.getRawBuffer(), msg.getOffset(), msg.getLength()));
        this.passItDown(new Event(1, msgEncrypted));
    }

    private synchronized byte[] encryptMessage(Cipher cipher, byte[] plain, int offset, int length) throws Exception {
        return cipher.doFinal(plain, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes;
        ENCRYPT eNCRYPT = this;
        synchronized (eNCRYPT) {
            keyBytes = this.asymCipher.doFinal(encodedKey);
        }
        SecretKeySpec keySpec = null;
        try {
            keySpec = new SecretKeySpec(keyBytes, ENCRYPT.getAlgorithm(this.symAlgorithm));
            Cipher temp = Cipher.getInstance(this.symAlgorithm);
            temp.init(3, keySpec);
        }
        catch (Exception e) {
            this.log.fatal(e.toString());
            keySpec = null;
        }
        return keySpec;
    }

    private PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ENCRYPT.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    private static String formatArray(byte[] array) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            buf.append(Integer.toHexString(array[i]));
        }
        return buf.toString();
    }

    protected int getAsymInit() {
        return this.asymInit;
    }

    protected String getAsymProvider() {
        return this.asymProvider;
    }

    protected SecretKey getDesKey() {
        return this.secretKey;
    }

    protected KeyPair getKpair() {
        return this.Kpair;
    }

    protected Cipher getAsymCipher() {
        return this.asymCipher;
    }

    protected PublicKey getServerPubKey() {
        return this.serverPubKey;
    }

    protected String getSymAlgorithm() {
        return this.symAlgorithm;
    }

    protected int getSymInit() {
        return this.symInit;
    }

    protected static String getSymProvider() {
        return symProvider;
    }

    protected String getAsymAlgorithm() {
        return this.asymAlgorithm;
    }

    private String getSymVersion() {
        return this.symVersion;
    }

    private void setSymVersion(String symVersion) {
        this.symVersion = symVersion;
    }

    private SecretKey getSecretKey() {
        return this.secretKey;
    }

    private void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    protected String getKeyStoreName() {
        return this.keyStoreName;
    }

    protected Cipher getSymDecodingCipher() {
        return this.symDecodingCipher;
    }

    protected Cipher getSymEncodingCipher() {
        return this.symEncodingCipher;
    }

    protected Address getLocal_addr() {
        return this.local_addr;
    }

    protected void setLocal_addr(Address local_addr) {
        this.local_addr = local_addr;
    }

    protected Address getKeyServerAddr() {
        return this.keyServerAddr;
    }

    protected void setKeyServerAddr(Address keyServerAddr) {
        this.keyServerAddr = keyServerAddr;
    }

    public static class EncryptHeader
    extends Header {
        short type;
        public static final short ENCRYPT = 0;
        public static final short KEY_REQUEST = 1;
        public static final short SERVER_PUBKEY = 2;
        public static final short SECRETKEY = 3;
        public static final short SECRETKEY_READY = 4;
        String version;
        boolean encrypt_entire_msg = false;

        public EncryptHeader() {
        }

        public EncryptHeader(short type) {
            this.type = type;
            this.version = "";
        }

        public EncryptHeader(short type, String version) {
            this.type = type;
            this.version = version;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeString(this.version, out);
            out.writeBoolean(this.encrypt_entire_msg);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.version = Util.readString(in);
            this.encrypt_entire_msg = in.readBoolean();
        }

        @Override
        public String toString() {
            return "ENCRYPT [type=" + this.type + " version=\"" + (this.version != null ? this.version.length() + " bytes" : "n/a") + "\"]";
        }

        @Override
        public int size() {
            int retval = 4;
            if (this.version != null) {
                retval += this.version.length() + 2;
            }
            return retval;
        }

        protected short getType() {
            return this.type;
        }

        protected String getVersion() {
            return this.version;
        }
    }

    static interface Observer {
        public void up(Event var1);

        public void passUp(Event var1);

        public void down(Event var1);

        public void passDown(Event var1);
    }
}

