/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.buildtime.AbstractInstrumenter;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.Logger;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.objectweb.asm.ClassReader;

public class CGLIBInstrumenter
extends AbstractInstrumenter {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();

    public CGLIBInstrumenter(Logger logger, Instrumenter.Options options) {
        super(logger, options);
    }

    protected ClassDescriptor getClassDescriptor(byte[] byecode) throws Exception {
        return new CustomClassDescriptor(byecode);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor descriptor, Set classNames) {
        if (descriptor.isInstrumented()) {
            this.logger.debug("class [" + descriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new AbstractInstrumenter.CustomFieldFilter(this, descriptor, classNames));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytecode;
        private final String name;
        private final boolean isInstrumented;

        public CustomClassDescriptor(byte[] bytecode) throws Exception {
            this.bytecode = bytecode;
            ClassReader reader = new ClassReader((InputStream)new ByteArrayInputStream(bytecode));
            String[] names = ClassNameReader.getClassInfo((ClassReader)reader);
            this.name = names[0];
            boolean instrumented = false;
            for (int i = 1; i < names.length; ++i) {
                if (!InterceptFieldEnabled.class.getName().equals(names[i])) continue;
                instrumented = true;
                break;
            }
            this.isInstrumented = instrumented;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public byte[] getBytes() {
            return this.bytecode;
        }
    }
}

