/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.deployer.kernel;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.beans.metadata.api.annotations.Bean;
import org.jboss.beans.metadata.api.annotations.BeanFactory;
import org.jboss.beans.metadata.plugins.AbstractAliasMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.deployers.plugins.annotations.AbstractAnnotationDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractAnnotationProcessor;
import org.jboss.deployers.spi.deployer.helpers.AnnotationProcessor;

public class BeanScanningDeployer
extends AbstractAnnotationDeployer {
    public BeanScanningDeployer() {
        super(new AnnotationProcessor[]{new BeanAnnotationProcessor(), new BeanFactoryAnnotationProcessor()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanFactoryAnnotationProcessor
    extends AbstractAnnotationProcessor<BeanFactory, BeanMetaData> {
        private BeanFactoryAnnotationProcessor() {
        }

        public Class<BeanFactory> getAnnotation() {
            return BeanFactory.class;
        }

        public Class<BeanMetaData> getOutput() {
            return BeanMetaData.class;
        }

        protected BeanMetaData createMetaDataFromClass(Class<?> clazz, BeanFactory factory) {
            String[] aliases;
            String name = factory.name();
            if (name == null) {
                throw new IllegalArgumentException("Null bean name: " + factory);
            }
            GenericBeanFactoryMetaData gbfmd = new GenericBeanFactoryMetaData(name, clazz.getName());
            Class factoryClass = factory.getFactoryClass();
            if (!Void.TYPE.equals(factoryClass)) {
                gbfmd.setFactoryClass(factoryClass.getName());
            }
            if ((aliases = factory.aliases()) != null && aliases.length > 0) {
                HashSet<AbstractAliasMetaData> aliasesMD = new HashSet<AbstractAliasMetaData>();
                for (String alias : aliases) {
                    AbstractAliasMetaData aamd = new AbstractAliasMetaData();
                    aamd.setAlias((Object)alias);
                    aliasesMD.add(aamd);
                }
                gbfmd.setAliases(aliasesMD);
            }
            gbfmd.setMode(factory.mode());
            gbfmd.setAccessMode(factory.accessMode());
            return gbfmd.getBeanMetaData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanAnnotationProcessor
    extends AbstractAnnotationProcessor<Bean, BeanMetaData> {
        private BeanAnnotationProcessor() {
        }

        public Class<Bean> getAnnotation() {
            return Bean.class;
        }

        public Class<BeanMetaData> getOutput() {
            return BeanMetaData.class;
        }

        protected BeanMetaData createMetaDataFromClass(Class<?> clazz, Bean bean) {
            String name = bean.name();
            if (name == null) {
                throw new IllegalArgumentException("Null bean name: " + clazz);
            }
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)clazz.getName());
            String[] aliases = bean.aliases();
            if (aliases != null && aliases.length > 0) {
                builder.setAliases(new HashSet<String>(Arrays.asList(aliases)));
            }
            builder.setMode(bean.mode()).setAccessMode(bean.accessMode()).setAutowireType(bean.autowireType()).setErrorHandlingMode(bean.errorHandlingMode()).setAutowireCandidate(bean.autowireCandidate());
            return builder.getBeanMetaData();
        }
    }
}

