/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpPortal;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public final class SnmpTrapSession {
    public static final int ERROR_EXCEPTION = -1;
    public static final int ERROR_INVALID_PDU = -2;
    public static final int DEFAULT_PORT = 162;
    private int m_port;
    private SnmpPortal m_portal;
    private AsnEncoder m_encoder;
    private SnmpTrapHandler m_handler;
    private boolean m_threadException;
    private Throwable m_why;

    private SnmpTrapSession() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal constructor call");
    }

    public SnmpTrapSession(SnmpTrapHandler handler) throws SocketException {
        this(handler, 162, null);
    }

    public SnmpTrapSession(SnmpTrapHandler handler, int port) throws SocketException {
        this(handler, port, null);
    }

    public SnmpTrapSession(SnmpTrapHandler handler, int port, InetAddress laddr) throws SocketException {
        this.m_port = port;
        this.m_encoder = new SnmpParameters().getEncoder();
        this.m_handler = handler;
        this.m_portal = new SnmpPortal(new TrapHandler(this), this.m_encoder, this.m_port, laddr);
        this.m_threadException = false;
        this.m_why = null;
    }

    public SnmpTrapHandler getHandler() {
        return this.m_handler;
    }

    public void setHandler(SnmpTrapHandler hdl) {
        this.m_handler = hdl;
    }

    public void setAsnEncoder(AsnEncoder encoder) {
        this.m_encoder = encoder;
        this.m_portal.setAsnEncoder(encoder);
    }

    public AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    public boolean isClosed() {
        return this.m_portal.isClosed();
    }

    public void close() {
        if (this.m_portal.isClosed()) {
            throw new IllegalStateException("Illegal operation, the session is already closed");
        }
        this.m_portal.close();
    }

    public void raise() throws Throwable {
        if (this.m_threadException) {
            throw this.m_why;
        }
    }

    public void send(SnmpPeer peer, SnmpPduTrap trap) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        if (this.m_portal.isClosed()) {
            throw new IllegalStateException("Illegal operation, the session has been closed");
        }
        SnmpParameters parms = peer.getParameters();
        if (parms.getVersion() != 0) {
            throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
        }
        AsnEncoder encoder = parms.getEncoder();
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, encoder);
        SnmpOctetString community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        offset = community.encodeASN(buf, offset, encoder);
        int pivot = offset = trap.encodeASN(buf, offset, encoder);
        offset = encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        this.m_portal.send(peer, buf, offset);
    }

    public void send(SnmpPeer peer, SnmpPduPacket pdu) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        if (this.m_portal.isClosed()) {
            throw new IllegalStateException("Illegal operation, the session has been closed");
        }
        SnmpParameters parms = peer.getParameters();
        if (parms.getVersion() < 1) {
            throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
        }
        switch (pdu.getCommand()) {
            case 162: 
            case 167: {
                break;
            }
            default: {
                throw new SnmpPduEncodingException("Invalid pdu, not a V2TRAP or RESPONSE (to INFORM request)");
            }
        }
        AsnEncoder encoder = parms.getEncoder();
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, encoder);
        SnmpOctetString community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        offset = community.encodeASN(buf, offset, encoder);
        int pivot = offset = pdu.encodeASN(buf, offset, encoder);
        offset = encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        this.m_portal.send(peer, buf, offset);
    }

    private class TrapHandler
    implements SnmpPacketHandler {
        private SnmpTrapSession m_forWhom;

        public TrapHandler(SnmpTrapSession sess) {
            this.m_forWhom = sess;
        }

        public void processSnmpMessage(InetAddress agent, int port, SnmpInt32 version, SnmpOctetString community, int pduType, SnmpPduPacket pdu) {
            if (version.getValue() != 1 && pduType != 167) {
                return;
            }
            try {
                SnmpTrapSession.this.m_handler.snmpReceivedTrap(this.m_forWhom, agent, port, community, pdu);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void processSnmpTrap(InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) {
            try {
                SnmpTrapSession.this.m_handler.snmpReceivedTrap(this.m_forWhom, agent, port, community, pdu);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void processBadDatagram(DatagramPacket p) {
        }

        public void processException(Exception e) {
            try {
                SnmpTrapSession.this.m_handler.snmpTrapSessionError(this.m_forWhom, -1, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

