/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

class SnmpRequest
implements Runnable {
    private Integer m_requestID;
    private SnmpSession m_session;
    private SnmpSyntax m_pdu;
    private SnmpHandler m_handler;
    private int m_timesSent;
    private boolean m_expired;
    private boolean m_isTrap;

    SnmpRequest(SnmpSession session, Integer requestID, SnmpPduPacket pdu, SnmpHandler handler) {
        this.m_session = session;
        this.m_requestID = requestID;
        this.m_pdu = pdu;
        this.m_handler = handler;
        this.m_isTrap = pdu.getCommand() == 167;
    }

    SnmpRequest(SnmpSession session, SnmpPduTrap pdu, SnmpHandler handler) {
        this.m_session = session;
        this.m_pdu = pdu;
        this.m_handler = handler;
        this.m_isTrap = true;
    }

    public void run() {
        block9: {
            if (this.m_expired) {
                return;
            }
            if (this.m_timesSent < this.m_session.getPeer().getRetries()) {
                ++this.m_timesSent;
                try {
                    this.m_session.transmit(this);
                    if (this.m_isTrap) {
                        this.m_expired = true;
                        break block9;
                    }
                    this.m_session.getTimer().schedule(this, this.m_session.getPeer().getTimeout());
                }
                catch (IOException err) {
                    this.m_session.snmpInternalError(this, -2);
                }
                catch (SnmpPduEncodingException err) {
                    this.m_session.snmpInternalError(this, -3);
                }
                catch (AsnEncodingException err) {
                    this.m_session.snmpInternalError(this, -3);
                }
                catch (RuntimeException ex) {
                    this.m_session.snmpInternalError(this, -4);
                }
            } else {
                this.m_session.snmpTimeoutError(this);
            }
        }
    }

    public boolean isTrap() {
        return this.m_isTrap;
    }

    public boolean isExpired() {
        return this.m_expired;
    }

    public void setExpired(boolean expired) {
        this.m_expired = expired;
    }

    public SnmpHandler getHandler() {
        return this.m_handler;
    }

    public SnmpSyntax getPdu() {
        return this.m_pdu;
    }

    public Integer getRequestID() {
        return this.m_requestID;
    }
}

