/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.HashSet;
import javax.security.jacc.URLPattern;

class URLPatternSpec {
    URLPattern urlPattern;
    HashSet<URLPattern> urlPatternList;

    URLPatternSpec(String spec) {
        if (spec == null) {
            this.urlPattern = new URLPattern("/");
        } else if (spec.indexOf(":") > 0) {
            String[] patterns = spec.split(":");
            this.urlPatternList = new HashSet();
            for (String pattern : patterns) {
                URLPattern p = new URLPattern(pattern);
                if (this.urlPattern == null) {
                    this.urlPattern = p;
                    continue;
                }
                if (p.matches(this.urlPattern)) {
                    String msg = "1: URLPatternList item: " + pattern + " matches: " + this.urlPattern.getPattern();
                    throw new IllegalArgumentException(msg);
                }
                if (this.urlPattern.isPrefix()) {
                    if (!p.isPrefix() && !p.isExact()) {
                        String msg = "2: URLPatternList item: " + pattern + " is not an exact or prefix pattern";
                        throw new IllegalArgumentException(msg);
                    }
                } else if (this.urlPattern.isExtension()) {
                    if (!p.isPrefix() && !p.isExact()) {
                        String msg = "3: URLPatternList item: " + pattern + " is not an exact or prefix pattern";
                        throw new IllegalArgumentException(msg);
                    }
                } else if (this.urlPattern.isDefault()) {
                    if (p.isDefault()) {
                        String msg = "4: URLPatternList item: " + pattern + " cannot be the default pattern";
                        throw new IllegalArgumentException(msg);
                    }
                } else if (this.urlPattern.isExact()) {
                    String msg = "5: URLPatternList item: " + pattern + " is not allowed in an exact pattern";
                    throw new IllegalArgumentException(msg);
                }
                this.urlPatternList.add(p);
            }
        } else {
            this.urlPattern = new URLPattern(spec);
        }
    }

    boolean implies(URLPatternSpec spec) {
        boolean implies = this.urlPattern.matches(spec.urlPattern);
        if (implies) {
            if (this.urlPatternList != null) {
                for (URLPattern p : this.urlPatternList) {
                    if (!p.matches(spec.urlPattern)) continue;
                    return false;
                }
            }
            if (this.urlPatternList != null && spec.urlPatternList != null) {
                for (URLPattern p : this.urlPatternList) {
                    boolean hasMatch = false;
                    for (URLPattern p2 : spec.urlPatternList) {
                        if (!p.matches(p2)) continue;
                        hasMatch = true;
                        break;
                    }
                    if (hasMatch) continue;
                    return false;
                }
            }
        }
        return implies;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.urlPattern.hashCode();
        if (this.urlPatternList != null) {
            result = 37 * result + this.urlPatternList.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLPatternSpec)) {
            return false;
        }
        URLPatternSpec other = (URLPatternSpec)obj;
        return this.urlPattern.equals(other.urlPattern) && (this.urlPatternList == null || this.urlPatternList.equals(other.urlPatternList));
    }
}

