/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.SpiUtils;

final class InboundClient
implements Closeable {
    private final LocalRequestHandler handler;
    private final RemoteConnectionHandler remoteConnectionHandler;
    private final int id;

    InboundClient(RemoteConnectionHandler remoteConnectionHandler, LocalRequestHandler handler, int id) {
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.handler = handler;
        this.id = id;
        handler.addCloseHandler(SpiUtils.closingCloseHandler(this));
    }

    LocalRequestHandler getHandler() {
        return this.handler;
    }

    RemoteConnectionHandler getRemoteConnectionHandler() {
        return this.remoteConnectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RemoteConnection remoteConnection = this.remoteConnectionHandler.getRemoteConnection();
        ByteBuffer buffer = remoteConnection.allocate();
        try {
            buffer.position(4);
            buffer.put((byte)21);
            buffer.putInt(this.id);
            buffer.flip();
            try {
                remoteConnection.sendBlocking(buffer, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            remoteConnection.free(buffer);
        }
    }
}

