/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.filter;

import org.jboss.classloader.spi.filter.ClassFilter;

public class CombiningClassFilter
implements ClassFilter {
    private static final long serialVersionUID = -2504634309000740765L;
    private boolean and = false;
    private ClassFilter[] filters;

    public static CombiningClassFilter create(ClassFilter ... filters) {
        return new CombiningClassFilter(false, filters);
    }

    public static CombiningClassFilter create(boolean and, ClassFilter ... filters) {
        return new CombiningClassFilter(and, filters);
    }

    public CombiningClassFilter(boolean and, ClassFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException("Null filters");
        }
        this.and = and;
        this.filters = filters;
    }

    public boolean matchesClassName(String className) {
        for (ClassFilter filter : this.filters) {
            if (filter.matchesClassName(className)) {
                return true;
            }
            if (!this.and) continue;
            return false;
        }
        return false;
    }

    public boolean matchesResourcePath(String resourcePath) {
        for (ClassFilter filter : this.filters) {
            if (filter.matchesResourcePath(resourcePath)) {
                return true;
            }
            if (!this.and) continue;
            return false;
        }
        return false;
    }

    public boolean matchesPackageName(String packageName) {
        for (ClassFilter filter : this.filters) {
            if (filter.matchesPackageName(packageName)) {
                return true;
            }
            if (!this.and) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.filters.length; ++i) {
            builder.append(this.filters[i]);
            if (i >= this.filters.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

