/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    private static final Method getClassLoader = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Method method = BaseClassLoaderSource.class.getDeclaredMethod("getClassLoader", new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot get classloader from " + BaseClassLoaderSource.class.getName(), e);
            }
        }
    });

    SecurityActions() {
    }

    public static ClassLoader getParent(ClassLoader loader) {
        if (System.getSecurityManager() == null) {
            return GetParentAction.NON_PRIVILEGED.getParent(loader);
        }
        return GetParentAction.PRIVILEGED.getParent(loader);
    }

    static ClassLoader getClassLoader(BaseClassLoaderSource clSource) {
        try {
            return (ClassLoader)getClassLoader.invoke((Object)clSource, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return LoadClassAction.NON_PRIVILEGED.loadClass(loader, name);
        }
        return LoadClassAction.PRIVILEGED.loadClass(loader, name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LoadClassAction {
        public static final LoadClassAction NON_PRIVILEGED = new LoadClassAction(){

            @Override
            public Class<?> loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
                return loader.loadClass(name);
            }
        };
        public static final LoadClassAction PRIVILEGED = new LoadClassAction(){

            @Override
            public Class<?> loadClass(final ClassLoader loader, final String name) throws ClassNotFoundException {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return loader.loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw new RuntimeException(e.getCause());
                    }
                    if (e.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
            }
        };

        public Class<?> loadClass(ClassLoader var1, String var2) throws ClassNotFoundException;
    }

    static interface GetParentAction {
        public static final GetParentAction NON_PRIVILEGED = new GetParentAction(){

            public ClassLoader getParent(ClassLoader loader) {
                return loader.getParent();
            }
        };
        public static final GetParentAction PRIVILEGED = new GetParentAction(){

            public ClassLoader getParent(final ClassLoader loader) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            return loader.getParent();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e.getException());
                }
            }
        };

        public ClassLoader getParent(ClassLoader var1);
    }
}

