/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management;

import java.util.Collections;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.plugins.AbstractScopeInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQControlRuntimeDispatchPlugin
extends JBossObject
implements KernelRegistryEntry,
InvokeDispatchContext {
    private final ObjectName objectName;
    private final MBeanServer mbeanServer;

    public HornetQControlRuntimeDispatchPlugin(ObjectName objectName, MBeanServer mbeanServer) {
        if (objectName == null) {
            throw new IllegalArgumentException("null object name");
        }
        if (mbeanServer == null) {
            throw new IllegalArgumentException("null mbean server");
        }
        this.objectName = objectName;
        this.mbeanServer = mbeanServer;
    }

    public Object get(String name) throws Throwable {
        return this.mbeanServer.getAttribute(this.objectName, HornetQControlRuntimeDispatchPlugin.getAttributeName(name));
    }

    public void set(String name, Object value) throws Throwable {
        Attribute attribute = new Attribute(HornetQControlRuntimeDispatchPlugin.getAttributeName(name), value);
        this.mbeanServer.setAttribute(this.objectName, attribute);
    }

    public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable {
        return this.mbeanServer.invoke(this.objectName, name, parameters, signature);
    }

    public ClassLoader getClassLoader() throws Throwable {
        return this.mbeanServer.getClassLoader(this.objectName);
    }

    public Object getName() {
        return this.objectName;
    }

    public void setName(Object name) {
    }

    protected static String getAttributeName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        char firstCharacter = name.charAt(0);
        if (Character.isLowerCase(firstCharacter)) {
            String attributeName = String.valueOf(Character.toUpperCase(firstCharacter));
            if (name.length() > 1) {
                attributeName = attributeName + name.substring(1);
            }
            return attributeName;
        }
        return name;
    }

    public Set<Object> getAliases() {
        return Collections.emptySet();
    }

    public Controller getController() {
        throw new NotImplementedException("getController");
    }

    public DependencyInfo getDependencyInfo() {
        return null;
    }

    public ScopeInfo getScopeInfo() {
        return new AbstractScopeInfo(this.getName(), null);
    }

    public Object getTarget() {
        return null;
    }

    public Throwable getError() {
        throw new NotImplementedException("getError");
    }

    public ControllerState getState() {
        boolean registered = this.mbeanServer.isRegistered(this.objectName);
        return registered ? ControllerState.INSTALLED : ControllerState.NOT_INSTALLED;
    }

    public void setState(ControllerState state) {
        throw new NotImplementedException("setState");
    }

    public ControllerState getRequiredState() {
        return ControllerState.INSTALLED;
    }

    public void setRequiredState(ControllerState state) {
        throw new NotImplementedException("setRequiredState");
    }

    public ControllerMode getMode() {
        return ControllerMode.MANUAL;
    }

    public void setMode(ControllerMode mode) {
        throw new NotImplementedException("setMode");
    }

    public ErrorHandlingMode getErrorHandlingMode() {
        return ErrorHandlingMode.DISCARD;
    }

    public void install(ControllerState fromState, ControllerState toState) throws Throwable {
        throw new NotImplementedException("install");
    }

    public void setController(Controller controller) {
        throw new NotImplementedException("setController");
    }

    public void setError(Throwable error) {
        throw new NotImplementedException("NYI setError");
    }

    public void uninstall(ControllerState fromState, ControllerState toState) {
        throw new NotImplementedException("uninstall");
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("target=").append((Object)this.objectName);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append((Object)this.objectName);
    }
}

