/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvokerProxyHA;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.logging.Logger;
import org.jboss.proxy.Interceptor;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public abstract class AbstractTransactionStickyInterceptor
extends Interceptor {
    private static final Map txStickyTargets = Collections.synchronizedMap(new WeakHashMap());
    private FamilyClusterInfo familyClusterInfo;
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    protected static boolean trace = false;

    public AbstractTransactionStickyInterceptor() {
        trace = this.log.isTraceEnabled();
    }

    protected void putIfExistsTransactionTarget(Invocation invocation) throws Exception {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            Object stickyTarget;
            if (trace) {
                this.log.trace((Object)("In the proxy, transaction propagation context (tpc) is " + tpc));
                this.log.trace((Object)("Contains key returns " + txStickyTargets.containsKey(tpc)));
            }
            if ((stickyTarget = txStickyTargets.get(tpc)) != null) {
                if (this.getFamilyClusterInfo(invocation).getTargets().contains(stickyTarget)) {
                    if (trace) {
                        this.log.trace((Object)("Put transaction bound target into transient payload: " + stickyTarget));
                    }
                    invocation.getTransientPayload().put("TX_STICKY_TARGET", stickyTarget);
                } else {
                    throw new ServiceUnavailableException("Transaction sticky target is no longer available, so invocation needs to be halted");
                }
            }
        }
    }

    protected void rememberTransactionTarget(Invocation invocation, Object tpc) {
        Object stickyTarget;
        if (trace) {
            this.log.trace((Object)("After reaching the server, transaction propagation context (tpc) is " + tpc));
        }
        if ((stickyTarget = invocation.getTransientValue((Object)"TX_STICKY_TARGET")) != null) {
            if (trace) {
                this.log.trace((Object)("Remember transaction bound target [" + stickyTarget + "] for tpc " + tpc));
            }
            txStickyTargets.put(tpc, stickyTarget);
            InvokerProxyHA proxy = (InvokerProxyHA)invocation.getInvocationContext().getInvoker();
            proxy.forbidTransactionFailover(tpc);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        trace = this.log.isTraceEnabled();
    }

    protected Object getTransactionPropagationContext() {
        TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        if (trace) {
            this.log.trace((Object)("Using tpc factory " + tpcFactory));
        }
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    protected synchronized FamilyClusterInfo getFamilyClusterInfo(Invocation invocation) throws Exception {
        if (this.familyClusterInfo == null) {
            InvokerProxyHA proxy = (InvokerProxyHA)invocation.getInvocationContext().getInvoker();
            this.familyClusterInfo = proxy.getFamilyClusterInfo();
        }
        return this.familyClusterInfo;
    }
}

