/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.singleton.HASingletonControllerMBean;
import org.jboss.ha.singleton.HASingletonSupport;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASingletonController
extends HASingletonSupport
implements HASingletonControllerMBean {
    private ObjectName mSingletonMBean;
    private Object mSingleton;
    private String mSingletonStartMethod = "startSingleton";
    private String mSingletonStopMethod = "stopSingleton";
    private String mSingletonStartMethodArgument;
    private String mSingletonStopMethodArgument;
    private static final Object[] NO_ARGS = new Object[0];
    private static final String[] NO_TYPE_NAMES = new String[0];
    private static final Class<?>[] NO_TYPES = new Class[0];

    @Override
    public Object getTarget() {
        return this.mSingleton;
    }

    @Override
    public void setTarget(Object target) {
        this.mSingleton = target;
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="JMX ObjectName of the service controlled by this controller")
    public ObjectName getTargetName() {
        return this.mSingletonMBean;
    }

    @Override
    public void setTargetName(ObjectName targetObjectName) {
        this.mSingletonMBean = targetObjectName;
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Name of the method to invoke on the target when this node becomes the singleton master")
    public String getTargetStartMethod() {
        return this.mSingletonStartMethod;
    }

    @Override
    public void setTargetStartMethod(String targetStartMethod) throws InvalidParameterException {
        if (targetStartMethod != null) {
            this.mSingletonStartMethod = targetStartMethod;
        }
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Name of the method to invoke on the target when this node stops being the singleton master")
    public String getTargetStopMethod() {
        return this.mSingletonStopMethod;
    }

    @Override
    public void setTargetStopMethod(String targetStopMethod) throws InvalidParameterException {
        if (targetStopMethod != null) {
            this.mSingletonStopMethod = targetStopMethod;
        }
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Single string parameter to pass to the target's start method when this node becomes the singleton master")
    public String getTargetStartMethodArgument() {
        return this.mSingletonStartMethodArgument;
    }

    @Override
    public void setTargetStartMethodArgument(String targetStartMethodArgument) {
        this.mSingletonStartMethodArgument = targetStartMethodArgument;
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Single string parameter to pass to the target's stop method when this node stops being the singleton master")
    public String getTargetStopMethodArgument() {
        return this.mSingletonStopMethodArgument;
    }

    @Override
    public void setTargetStopMethodArgument(String targetStopMethodArgument) {
        this.mSingletonStopMethodArgument = targetStopMethodArgument;
    }

    @Override
    public void startSingleton() {
        this.log.debug((Object)("starting singleton, mSingleton=" + this.mSingleton + ", mSingletonMBean=" + this.mSingletonMBean));
        super.startSingleton();
        try {
            if (this.mSingleton != null) {
                this.invokeSingletonMethod(this.mSingleton, this.mSingletonStartMethod, this.mSingletonStartMethodArgument);
            } else if (this.mSingletonMBean != null) {
                this.invokeSingletonMBeanMethod(this.mSingletonMBean, this.mSingletonStartMethod, this.mSingletonStartMethodArgument);
            } else {
                this.log.warn((Object)"No singleton configured; cannot start");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Controlled Singleton failed to become master", (Throwable)e);
        }
    }

    @Override
    public void stopSingleton() {
        super.stopSingleton();
        try {
            if (this.mSingleton != null) {
                this.invokeSingletonMethod(this.mSingleton, this.mSingletonStopMethod, this.mSingletonStopMethodArgument);
            } else if (this.mSingletonMBean != null) {
                this.invokeSingletonMBeanMethod(this.mSingletonMBean, this.mSingletonStopMethod, this.mSingletonStopMethodArgument);
            } else {
                this.log.warn((Object)"No singleton configured; cannot start");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Controlled Singleton failed to resign from master position", (Throwable)e);
        }
    }

    protected Object invokeSingletonMethod(Object target, String operationName, Object param) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (target != null && operationName != null) {
            Class<?>[] types;
            Object[] params;
            if (param != null) {
                params = new Object[]{param};
                types = new Class[]{param.getClass()};
                this.log.debug((Object)("Calling operation: " + operationName + "(" + param + "), on target: '" + target + "'"));
            } else {
                params = NO_ARGS;
                types = NO_TYPES;
                this.log.debug((Object)("Calling operation: " + operationName + "(), on target: '" + target + "'"));
            }
            Method method = HASingletonController.getTargetMethod(target, operationName, types);
            return method.invoke(target, params);
        }
        this.log.debug((Object)"No configured target mbean or operation to call");
        return null;
    }

    protected Object invokeSingletonMBeanMethod(ObjectName target, String operationName, Object param) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (target != null && operationName != null) {
            String[] signature;
            Object[] params;
            if (param != null) {
                params = new Object[]{param};
                signature = new String[]{param.getClass().getName()};
                this.log.debug((Object)("Calling operation: " + operationName + "(" + param + "), on target: '" + target + "'"));
            } else {
                params = NO_ARGS;
                signature = NO_TYPE_NAMES;
                this.log.debug((Object)("Calling operation: " + operationName + "(), on target: '" + target + "'"));
            }
            return this.server.invoke(target, operationName, params, signature);
        }
        this.log.debug((Object)"No configured target mbean or operation to call");
        return null;
    }

    public static Method getTargetMethod(Object target, String methodName, Class<?>[] types) throws NoSuchMethodException {
        NoSuchMethodException nsme = null;
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, types);
                return method;
            }
            catch (NoSuchMethodException e) {
                if (nsme != null) continue;
                nsme = e;
                continue;
            }
        }
        throw nsme;
    }
}

