/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.ejb.Container;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.invocation.Invocation;

public class CleanShutdownInterceptor
extends AbstractInterceptor {
    protected Container container = null;
    protected EjbModule ejbModule = null;
    protected String ejbModuleName = null;
    private static ThreadLocal<String> currentModule = new ThreadLocal();
    protected boolean allowInvocations = false;
    protected boolean allowRemoteInvocations = false;
    protected boolean isDebugEnabled = false;
    public long runningInvocations = 0L;
    public long runningHomeInvocations = 0L;
    public long shutdownTimeout = 60000L;
    public long readAcquireTimeMs = 10000L;
    protected ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private static final String METHOD_INVOCATION_TAG = "WrappingEjbModuleName";

    public void onlyAllowLocalInvocations() {
        if (this.isDebugEnabled) {
            this.log.debug((Object)("Only allow local invocation from now on: " + this.container.getServiceName().toString()));
        }
        this.allowRemoteInvocations = false;
    }

    public void waitForNoMoreInvocations() {
        this.log.debug((Object)("Waiting that the container " + this.container.getJmxName() + " finishes its running invocations. " + this.runningHomeInvocations + " current home invocations and " + this.runningInvocations + " current remote invocations."));
        this.purgeRunningInvocations();
        if (this.isDebugEnabled) {
            this.log.debug((Object)"... Done: no more remote invocations currently running in this container.");
        }
    }

    public void create() throws Exception {
        super.create();
        this.allowInvocations = false;
        this.allowRemoteInvocations = false;
        this.isDebugEnabled = this.log.isDebugEnabled();
        this.ejbModuleName = this.ejbModule.getServiceName().toString();
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute("State");
        this.container.getServer().addNotificationListener(this.container.getEjbModule().getServiceName(), new StateChangeListener(), (NotificationFilter)filter, null);
        this.ejbModule.putModuleData((Object)("CleanShutDownInterceptor-" + this.container.getServiceName().toString()), (Object)this);
    }

    public void start() throws Exception {
        super.start();
        this.allowInvocations = true;
        this.allowRemoteInvocations = true;
    }

    public void stop() {
        super.stop();
        this.log.debug((Object)("Stopping container " + this.container.getJmxName() + ". " + this.runningHomeInvocations + " current home invocations and " + this.runningInvocations + " current remote invocations."));
        this.forbidInvocations();
    }

    public void destroy() {
        super.destroy();
        this.log.debug((Object)("Destroying container " + this.container.getJmxName().toString() + ". " + this.runningHomeInvocations + " current home invocations and " + this.runningInvocations + " current remote invocations."));
        this.forbidInvocations();
    }

    public Object invokeHome(Invocation mi) throws Exception {
        if (this.allowInvocations) {
            String origin = this.getOrigin(mi);
            boolean isAppLocalCall = this.ejbModuleName.equals(origin);
            if (!this.allowRemoteInvocations && !isAppLocalCall) {
                if (this.isDebugEnabled) {
                    this.log.debug((Object)("Refusing a remote home invocation. here= " + this.ejbModuleName + "; Origin= " + origin));
                }
                throw new GenericClusteringException(1, "This application does not accept remote calls any more");
            }
            try {
                if (!isAppLocalCall && !this.rwLock.readLock().tryLock(this.readAcquireTimeMs, TimeUnit.MILLISECONDS)) {
                    throw new GenericClusteringException(1, "Container is shuting down on this node (timeout)");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new GenericClusteringException(1, "Container is shuting down on this node");
            }
            ++this.runningHomeInvocations;
            try {
                if (!isAppLocalCall) {
                    this.setOrigin(mi);
                }
                Object ie = this.getNext().invokeHome(mi);
                return ie;
            }
            catch (GenericClusteringException gce) {
                gce.setCompletionStatus(2);
                throw gce;
            }
            finally {
                if (!isAppLocalCall) {
                    this.revertOrigin(mi, origin);
                }
                --this.runningHomeInvocations;
                if (!isAppLocalCall) {
                    this.rwLock.readLock().unlock();
                }
            }
        }
        throw new GenericClusteringException(1, "Container is not allowing invocations as it failed to start or is shutting down");
    }

    public Object invoke(Invocation mi) throws Exception {
        if (this.allowInvocations) {
            String origin = this.getOrigin(mi);
            boolean isAppLocalCall = this.ejbModuleName.equals(origin);
            if (!this.allowRemoteInvocations && !isAppLocalCall) {
                if (this.isDebugEnabled) {
                    this.log.debug((Object)"Refusing a remote invocation");
                }
                throw new GenericClusteringException(1, "This application does not accept remote calls any more");
            }
            try {
                if (!isAppLocalCall && !this.rwLock.readLock().tryLock(this.readAcquireTimeMs, TimeUnit.MILLISECONDS)) {
                    throw new GenericClusteringException(1, "Container is shuting down on this node (timeout)");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new GenericClusteringException(1, "Container is shuting down on this node");
            }
            ++this.runningInvocations;
            try {
                if (!isAppLocalCall) {
                    this.setOrigin(mi);
                }
                Object ie = this.getNext().invoke(mi);
                return ie;
            }
            catch (GenericClusteringException gce) {
                gce.setCompletionStatus(2);
                throw gce;
            }
            finally {
                if (!isAppLocalCall) {
                    this.revertOrigin(mi, origin);
                }
                --this.runningInvocations;
                if (!isAppLocalCall) {
                    this.rwLock.readLock().unlock();
                }
            }
        }
        throw new GenericClusteringException(1, "Container is not allowing invocations as it failed to start or is shutting down");
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container con) {
        this.container = con;
        this.ejbModule = con != null ? con.getEjbModule() : null;
    }

    protected void forbidInvocations() {
        this.allowInvocations = false;
        this.purgeRunningInvocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeRunningInvocations() {
        block5: {
            try {
                if (this.rwLock.writeLock().tryLock(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                    this.rwLock.writeLock().unlock();
                    break block5;
                }
                this.log.info((Object)("Possible running invocations not terminated while leaving the container. Home: " + this.runningHomeInvocations + ". Remote: " + this.runningInvocations + "."));
            }
            catch (Exception e) {
                this.log.info((Object)("Exception while waiting for running invocations to leave container. Home: " + this.runningHomeInvocations + ". Remote: " + this.runningInvocations + "."), (Throwable)e);
            }
        }
    }

    protected String getOrigin(Invocation mi) {
        String value = currentModule.get();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("GET_ORIGIN: " + value + " in " + this.container.getServiceName().toString()));
        }
        return value;
    }

    protected void setOrigin(Invocation mi) {
        currentModule.set(this.ejbModuleName);
    }

    protected void revertOrigin(Invocation mi, String origin) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Crossing ejbModule border from " + this.ejbModuleName + " to " + origin));
        }
        currentModule.set(origin);
    }

    protected void containerIsAboutToStop() {
        boolean iAmTheManager;
        if (this.ejbModule == null) {
            this.log.debug((Object)"Received STOPPING notification after container already set to null; ignoring");
            return;
        }
        this.log.debug((Object)"Container about to stop: disabling HA-RMI access to bean from interceptor");
        boolean bl = iAmTheManager = !Boolean.TRUE.equals(this.ejbModule.getModuleData((Object)"ShutdownInterceptorElected"));
        if (iAmTheManager) {
            this.ejbModule.putModuleData((Object)"ShutdownInterceptorElected", (Object)Boolean.TRUE);
            if (this.isDebugEnabled) {
                this.log.debug((Object)"Container is about to stop and I am the manager of the first step: blocking remote calls");
            }
            Collection containers = this.ejbModule.getContainers();
            for (Container otherContainer : containers) {
                CleanShutdownInterceptor inter = (CleanShutdownInterceptor)((Object)this.ejbModule.getModuleData((Object)("CleanShutDownInterceptor-" + otherContainer.getServiceName().toString())));
                if (inter == null) {
                    this.log.debug((Object)("Found an EJB that doesnt have a clean-shutdown interceptor: " + otherContainer.getJmxName()));
                    continue;
                }
                inter.onlyAllowLocalInvocations();
            }
        } else if (this.isDebugEnabled) {
            this.log.debug((Object)"Container is about to stop but I am not the manager: I don't manage the first step of the process.");
        }
        this.waitForNoMoreInvocations();
    }

    class StateChangeListener
    implements NotificationListener {
        StateChangeListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            AttributeChangeNotification notif;
            int value;
            if (notification instanceof AttributeChangeNotification && (value = ((Integer)(notif = (AttributeChangeNotification)notification).getNewValue()).intValue()) == 1) {
                CleanShutdownInterceptor.this.containerIsAboutToStop();
            }
        }
    }
}

