/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.metadata;

import java.util.Collections;
import java.util.Set;
import org.jboss.classloader.plugins.filter.EverythingClassFilter;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.spi.filter.RecursivePackageClassFilter;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.OptionalPackages;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.helpers.AbstractRequirement;
import org.jboss.classloading.spi.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageRequirement
extends AbstractRequirement
implements OptionalPackages {
    private static final long serialVersionUID = -7552921085464308835L;
    private transient ClassFilter filter;

    public PackageRequirement() {
    }

    public PackageRequirement(String name) {
        super(name);
    }

    public PackageRequirement(String name, VersionRange versionRange) {
        super(name, versionRange);
    }

    @Override
    public Set<String> getOptionalPackageNames(Module module) {
        if (!this.isOptional()) {
            return null;
        }
        return Collections.singleton(this.getName());
    }

    public ClassFilter toClassFilter() {
        if (this.filter == null) {
            String packageName = this.getName();
            if ("*".equals(packageName)) {
                this.filter = EverythingClassFilter.INSTANCE;
            } else if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
                this.filter = RecursivePackageClassFilter.createRecursivePackageClassFilter((String[])new String[]{packageName});
            } else {
                this.filter = PackageClassFilter.createPackageClassFilter((String[])new String[]{packageName});
            }
        }
        return this.filter;
    }

    public boolean isWildcard() {
        return this.getName().endsWith("*");
    }

    @Override
    public boolean isConsistent(Requirement other) {
        return this.isConsistent(other, PackageRequirement.class);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PackageRequirement)) {
            return false;
        }
        return super.equals(obj);
    }
}

