/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.component;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.faces.render.Renderer;
import org.apache.myfaces.view.facelets.component.RepeatStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRepeat
extends UIComponentBase
implements NamingContainer {
    public static final String COMPONENT_TYPE = "facelets.ui.Repeat";
    public static final String COMPONENT_FAMILY = "facelets";
    private static final DataModel<?> EMPTY_MODEL = new ListDataModel(Collections.emptyList());
    private static final SavedState NullState = new SavedState();
    private Map<String, SavedState> _childState;
    private Object _value;
    private String _var;
    private int _end = -1;
    private int _count;
    private int _index = -1;
    private int _offset = -1;
    private int _size = -1;
    private int _step = -1;
    private String _varStatus;
    private transient StringBuffer _buffer;
    private transient DataModel<?> _model;
    private transient Object _origValue;
    private transient Object _origVarStatus;

    public UIRepeat() {
        this.setRendererType(COMPONENT_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getOffset() {
        if (this._offset != -1) {
            return this._offset;
        }
        ValueExpression ve = this.getValueExpression("offset");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return 0;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public int getSize() {
        if (this._size != -1) {
            return this._size;
        }
        ValueExpression ve = this.getValueExpression("size");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return -1;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public int getStep() {
        if (this._step != -1) {
            return this._step;
        }
        ValueExpression ve = this.getValueExpression("step");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return 1;
    }

    public void setStep(int step) {
        this._step = step;
    }

    public String getVar() {
        return this._var;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getVarStatus() {
        return this._varStatus;
    }

    public void setVarStatus(String varStatus) {
        this._varStatus = varStatus;
    }

    private synchronized void setDataModel(DataModel<?> model) {
        this._model = model;
    }

    private synchronized DataModel<?> getDataModel() {
        if (this._model == null) {
            Object val = this.getValue();
            this._model = val == null ? EMPTY_MODEL : (val instanceof DataModel ? (DataModel)val : (val instanceof List ? new ListDataModel((List)val) : (Object[].class.isAssignableFrom(val.getClass()) ? new ArrayDataModel((Object[])val) : (val instanceof ResultSet ? new ResultSetDataModel((ResultSet)val) : new ScalarDataModel(val)))));
        }
        return this._model;
    }

    public Object getValue() {
        ValueExpression ve;
        if (this._value == null && (ve = this.getValueExpression("value")) != null) {
            return ve.getValue(this.getFacesContext().getELContext());
        }
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getContainerClientId(FacesContext faces) {
        String id = super.getContainerClientId(faces);
        if (this._index >= 0) {
            id = this._getBuffer().append(id).append(UINamingContainer.getSeparatorChar((FacesContext)faces)).append(this._index).toString();
        }
        return id;
    }

    private RepeatStatus _getRepeatStatus() {
        return new RepeatStatus(this._count == 0, this._index + this.getStep() >= this.getDataModel().getRowCount(), this._count, this._index, this.getOffset(), this._end, this.getStep());
    }

    private void _captureScopeValues() {
        if (this._var != null) {
            this._origValue = this.getFacesContext().getExternalContext().getRequestMap().get(this._var);
        }
        if (this._varStatus != null) {
            this._origVarStatus = this.getFacesContext().getExternalContext().getRequestMap().get(this._varStatus);
        }
    }

    private StringBuffer _getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        this._buffer.setLength(0);
        return this._buffer;
    }

    private Map<String, SavedState> _getChildState() {
        if (this._childState == null) {
            this._childState = new HashMap<String, SavedState>();
        }
        return this._childState;
    }

    private boolean _isIndexAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    private boolean _isNestedInIterator() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData) && !(parent instanceof UIRepeat)) continue;
            return true;
        }
        return false;
    }

    private boolean _keepSaved(FacesContext context) {
        for (String clientId : this._getChildState().keySet()) {
            for (FacesMessage message : context.getMessageList(clientId)) {
                if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
                return true;
            }
        }
        return this._isNestedInIterator();
    }

    private void _resetDataModel() {
        if (this._isNestedInIterator()) {
            this.setDataModel(null);
        }
    }

    private void _restoreScopeValues() {
        Map attrs;
        if (this._var != null) {
            attrs = this.getFacesContext().getExternalContext().getRequestMap();
            if (this._origValue != null) {
                attrs.put(this._var, this._origValue);
                this._origValue = null;
            } else {
                attrs.remove(this._var);
            }
        }
        if (this._varStatus != null) {
            attrs = this.getFacesContext().getExternalContext().getRequestMap();
            if (this._origVarStatus != null) {
                attrs.put(this._varStatus, this._origVarStatus);
                this._origVarStatus = null;
            } else {
                attrs.remove(this._varStatus);
            }
        }
    }

    private void _restoreChildState() {
        if (this.getChildCount() > 0) {
            FacesContext context = this.getFacesContext();
            for (UIComponent child : this.getChildren()) {
                this._restoreChildState(context, child);
            }
        }
    }

    private void _restoreChildState(FacesContext faces, UIComponent c) {
        String id = c.getId();
        c.setId(id);
        if (c instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)c;
            String clientId = c.getClientId(faces);
            SavedState ss = this._getChildState().get(clientId);
            if (ss != null) {
                ss.apply(evh);
            } else {
                NullState.apply(evh);
            }
        }
        Iterator itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this._restoreChildState(faces, (UIComponent)itr.next());
        }
    }

    private void _saveChildState() {
        if (this.getChildCount() > 0) {
            FacesContext context = this.getFacesContext();
            for (UIComponent child : this.getChildren()) {
                this._saveChildState(context, child);
            }
        }
    }

    private void _saveChildState(FacesContext faces, UIComponent c) {
        if (c instanceof EditableValueHolder && !c.isTransient()) {
            String clientId = c.getClientId(faces);
            SavedState ss = this._getChildState().get(clientId);
            if (ss == null) {
                ss = new SavedState();
                this._getChildState().put(clientId, ss);
            }
            ss.populate((EditableValueHolder)c);
        }
        Iterator itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this._saveChildState(faces, (UIComponent)itr.next());
        }
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public int getIndex() {
        return this._index;
    }

    private void _setIndex(int index) {
        this._saveChildState();
        this._index = index;
        DataModel<?> localModel = this.getDataModel();
        localModel.setRowIndex(index);
        if (this._index != -1) {
            if (this._var != null && localModel.isRowAvailable()) {
                this.getFacesContext().getExternalContext().getRequestMap().put(this._var, localModel.getRowData());
            }
            if (this._varStatus != null) {
                this.getFacesContext().getExternalContext().getRequestMap().put(this._varStatus, this._getRepeatStatus());
            }
        }
        this._restoreChildState();
    }

    private int _calculateCountForIndex(int index) {
        return (index - this.getOffset()) / this.getStep();
    }

    private void _validateAttributes() throws FacesException {
        int begin = this.getOffset();
        int end = this.getDataModel().getRowCount();
        int size = this.getSize();
        int step = this.getStep();
        if (size == -1) {
            size = end;
        }
        if (end >= 0) {
            if (size < 0) {
                throw new FacesException("iteration size cannot be less than zero");
            }
            if (size > end) {
                throw new FacesException("iteration size cannot be greater than collection size");
            }
        }
        if (size > -1 && begin > size) {
            throw new FacesException("iteration offset cannot be greater than collection size");
        }
        if (step == -1) {
            step = 1;
        }
        if (step < 0) {
            throw new FacesException("iteration step size cannot be less than zero");
        }
        if (step == 0) {
            throw new FacesException("iteration step size cannot be equal to zero");
        }
        this._end = size;
        this._step = step;
    }

    public void process(FacesContext faces, PhaseId phase) {
        if (!this.isRendered()) {
            return;
        }
        this._validateAttributes();
        this._resetDataModel();
        this._captureScopeValues();
        this._setIndex(-1);
        try {
            if (this.getChildCount() > 0) {
                int i = this.getOffset();
                int end = this.getSize();
                int step = this.getStep();
                end = end >= 0 ? i + end : 0x7FFFFFFE;
                String rendererType = this.getRendererType();
                Renderer renderer = null;
                if (rendererType != null) {
                    renderer = this.getRenderer(faces);
                }
                this._count = 0;
                this._setIndex(i);
                while (i <= end && this._isIndexAvailable()) {
                    if (PhaseId.RENDER_RESPONSE.equals(phase) && renderer != null) {
                        renderer.encodeChildren(faces, (UIComponent)this);
                    } else {
                        for (UIComponent child : this.getChildren()) {
                            if (PhaseId.APPLY_REQUEST_VALUES.equals(phase)) {
                                child.processDecodes(faces);
                                continue;
                            }
                            if (PhaseId.PROCESS_VALIDATIONS.equals(phase)) {
                                child.processValidators(faces);
                                continue;
                            }
                            if (PhaseId.UPDATE_MODEL_VALUES.equals(phase)) {
                                child.processUpdates(faces);
                                continue;
                            }
                            if (!PhaseId.RENDER_RESPONSE.equals(phase)) continue;
                            child.encodeAll(faces);
                        }
                    }
                    ++this._count;
                    this._setIndex(i += step);
                }
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this._setIndex(-1);
            this._restoreScopeValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext faces, String clientId, ContextCallback callback) throws FacesException {
        String indexLessId = this.getClientId(faces);
        if (clientId.startsWith(indexLessId)) {
            int idxEnd;
            int invokeIndex = -1;
            int idxStart = clientId.indexOf(UINamingContainer.getSeparatorChar((FacesContext)faces), indexLessId.length());
            if (idxStart != -1 && Character.isDigit(clientId.charAt(idxStart + 1)) && (idxEnd = clientId.indexOf(UINamingContainer.getSeparatorChar((FacesContext)faces), idxStart + 1)) != -1) {
                invokeIndex = Integer.parseInt(clientId.substring(idxStart + 1, idxEnd));
            }
            int prevIndex = this._index;
            int prevCount = this._count;
            try {
                this._captureScopeValues();
                if (invokeIndex != -1) {
                    this._count = this._calculateCountForIndex(invokeIndex);
                }
                this._setIndex(invokeIndex);
                if (this._isIndexAvailable()) {
                    boolean bl = super.invokeOnComponent(faces, clientId, callback);
                    return bl;
                }
                if (clientId.equals(indexLessId)) {
                    callback.invokeContextCallback(faces, (UIComponent)this);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this._count = prevCount;
                this._setIndex(prevIndex);
                this._restoreScopeValues();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        int prevIndex = this._index;
        int prevCount = this._count;
        this._validateAttributes();
        this._resetDataModel();
        this._captureScopeValues();
        this._setIndex(-1);
        this.pushComponentToEL(context.getFacesContext(), (UIComponent)this);
        try {
            boolean doVisitChildren;
            VisitResult res = context.invokeVisitCallback((UIComponent)this, callback);
            switch (res) {
                case COMPLETE: {
                    boolean bl = true;
                    return bl;
                }
                case REJECT: {
                    boolean bl = false;
                    return bl;
                }
            }
            Collection subtreeIdsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
            boolean bl = doVisitChildren = subtreeIdsToVisit != null && !subtreeIdsToVisit.isEmpty();
            if (doVisitChildren) {
                if (this.getFacetCount() > 0) {
                    for (UIComponent facet : this.getFacets().values()) {
                        if (!facet.visitTree(context, callback)) continue;
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                if (this.getChildCount() > 0) {
                    int i = this.getOffset();
                    int end = this.getSize();
                    int step = this.getStep();
                    end = end >= 0 ? i + end : 0x7FFFFFFE;
                    this._count = 0;
                    this._setIndex(i);
                    while (i <= end && this._isIndexAvailable()) {
                        for (UIComponent child : this.getChildren()) {
                            if (!child.visitTree(context, callback)) continue;
                            boolean bl3 = true;
                            return bl3;
                        }
                        ++this._count;
                        this._setIndex(i += step);
                    }
                }
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.popComponentFromEL(context.getFacesContext());
            this._count = prevCount;
            this._setIndex(prevIndex);
            this._restoreScopeValues();
        }
    }

    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this._keepSaved(faces)) {
            this._childState = null;
        }
        this.process(faces, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(faces);
    }

    public void processUpdates(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this._resetDataModel();
        this.process(faces, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this._resetDataModel();
        this.process(faces, PhaseId.PROCESS_VALIDATIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof IndexedEvent) {
            IndexedEvent idxEvent = (IndexedEvent)event;
            this._resetDataModel();
            int prevIndex = this._index;
            int prevCount = this._count;
            try {
                this._captureScopeValues();
                if (idxEvent.getIndex() != -1) {
                    this._count = this._calculateCountForIndex(idxEvent.getIndex());
                }
                this._setIndex(idxEvent.getIndex());
                if (!this._isIndexAvailable()) return;
                FacesEvent target = idxEvent.getTarget();
                FacesContext facesContext = this.getFacesContext();
                UIComponent targetComponent = target.getComponent();
                UIComponent compositeParent = UIComponent.getCompositeComponentParent((UIComponent)targetComponent);
                if (compositeParent != null) {
                    this.pushComponentToEL(facesContext, compositeParent);
                }
                this.pushComponentToEL(facesContext, targetComponent);
                try {
                    targetComponent.broadcast(target);
                    return;
                }
                finally {
                    this.popComponentFromEL(facesContext);
                    if (compositeParent != null) {
                        this.popComponentFromEL(facesContext);
                    }
                }
            }
            finally {
                this._count = prevCount;
                this._setIndex(prevIndex);
                this._restoreScopeValues();
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new IndexedEvent(this, event, this._index));
    }

    public void restoreState(FacesContext faces, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        this._childState = (Map)state[1];
        this._offset = (Integer)state[2];
        this._size = (Integer)state[3];
        this._var = (String)state[4];
        this._value = state[5];
    }

    public Object saveState(FacesContext faces) {
        Object[] state = new Object[]{super.saveState(faces), this._childState, new Integer(this._offset), new Integer(this._size), this._var, this._value};
        return state;
    }

    public void encodeChildren(FacesContext faces) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this._keepSaved(faces)) {
            this._childState = null;
        }
        this.process(faces, PhaseId.RENDER_RESPONSE);
    }

    public boolean getRendersChildren() {
        Renderer renderer;
        if (this.getRendererType() != null && (renderer = this.getRenderer(this.getFacesContext())) != null) {
            return renderer.getRendersChildren();
        }
        return true;
    }

    private final class IndexedEvent
    extends FacesEvent {
        private final FacesEvent _target;
        private final int _index;

        public IndexedEvent(UIRepeat owner, FacesEvent target, int index) {
            super((UIComponent)owner);
            this._target = target;
            this._index = index;
        }

        public PhaseId getPhaseId() {
            return this._target.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this._target.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return this._target.isAppropriateListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processListener(FacesListener listener) {
            UIRepeat owner = (UIRepeat)this.getComponent();
            int prevIndex = owner._index;
            int prevCount = owner._count;
            try {
                owner._captureScopeValues();
                if (this._index != -1) {
                    UIRepeat.this._count = UIRepeat.this._calculateCountForIndex(this._index);
                }
                owner._setIndex(this._index);
                if (owner._isIndexAvailable()) {
                    this._target.processListener(listener);
                }
            }
            finally {
                owner._count = prevCount;
                owner._setIndex(prevIndex);
                owner._restoreScopeValues();
            }
        }

        public int getIndex() {
            return this._index;
        }

        public FacesEvent getTarget() {
            return this._target;
        }
    }

    private static final class SavedState
    implements Serializable {
        private boolean _localValueSet;
        private Object _submittedValue;
        private boolean _valid = true;
        private Object _value;
        private static final long serialVersionUID = 2920252657338389849L;

        private SavedState() {
        }

        Object getSubmittedValue() {
            return this._submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this._submittedValue = submittedValue;
        }

        boolean isValid() {
            return this._valid;
        }

        void setValid(boolean valid) {
            this._valid = valid;
        }

        Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        boolean isLocalValueSet() {
            return this._localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this._localValueSet = localValueSet;
        }

        public String toString() {
            return "submittedValue: " + this._submittedValue + " value: " + this._value + " localValueSet: " + this._localValueSet;
        }

        public void populate(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
            this._localValueSet = evh.isLocalValueSet();
        }

        public void apply(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
            evh.setLocalValueSet(this._localValueSet);
        }
    }
}

