/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.ejb3.interceptors.lang.SecurityActions;

public class ClassHelper {
    private static Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();

    private static boolean checkParameters(Class<?>[] parameterTypes, Class<?>[] methodParameterTypes) {
        if (parameterTypes.length != methodParameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType;
            Class<?> methodParameterType = methodParameterTypes[i];
            if (methodParameterType.isPrimitive()) {
                methodParameterType = primitiveWrapperMap.get(methodParameterType);
            }
            if ((parameterType = parameterTypes[i]).isPrimitive()) {
                parameterType = primitiveWrapperMap.get(parameterType);
            }
            if (methodParameterType.isAssignableFrom(parameterType)) continue;
            return false;
        }
        return true;
    }

    public static Method[] getAllMethods(Class<?> cls) {
        ArrayList<Method> list = new ArrayList<Method>();
        ClassHelper.populateAllMethods(cls, list);
        return list.toArray(new Method[0]);
    }

    public static Method getMethod(Class<?> cls, String methodName) throws NoSuchMethodException {
        Method[] methods;
        if (cls == null) {
            throw new NoSuchMethodException(methodName);
        }
        for (Method method : methods = cls.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        try {
            return ClassHelper.getMethod(cls.getSuperclass(), methodName);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("No method named " + methodName + " in " + cls + " (or super classes)");
        }
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ... params) throws NoSuchMethodException {
        if (cls == null) {
            throw new NoSuchMethodException("Class is null " + methodName);
        }
        Method m = ClassHelper.getDeclaredMethod(cls, methodName, params);
        if (m == null) {
            throw new NoSuchMethodException("No method named " + methodName + "(" + (params != null ? Arrays.toString(params) : "") + ") in " + cls + " (or super classes)");
        }
        return m;
    }

    private static Method getDeclaredMethod(Class<?> cls, String methodName, Class<?> ... params) {
        Method[] methods;
        for (Method method : methods = SecurityActions.getDeclaredMethods(cls)) {
            if (!method.getName().equals(methodName)) continue;
            if (params == null) {
                return method;
            }
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (params.length != methodParameterTypes.length || !ClassHelper.checkParameters(params, methodParameterTypes)) continue;
            return method;
        }
        try {
            return SecurityActions.getDeclaredMethod(cls, methodName, params);
        }
        catch (NoSuchMethodException e1) {
            if (cls == Object.class) {
                return null;
            }
            return ClassHelper.getDeclaredMethod(cls.getSuperclass(), methodName, params);
        }
    }

    public static Map<String, List<Method>> getAllMethodsMap(Class<?> cls) {
        HashMap<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
        ArrayList<Method> list = new ArrayList<Method>();
        ClassHelper.populateAllMethods(cls, list);
        for (Method method : list) {
            ArrayList<Method> methods = (ArrayList<Method>)methodMap.get(method.getName());
            if (methods == null) {
                methods = new ArrayList<Method>();
                methodMap.put(method.getName(), methods);
            }
            methods.add(method);
        }
        return methodMap;
    }

    private static void populateAllMethods(Class<?> cls, List<Method> methods) {
        if (cls == null) {
            return;
        }
        ClassHelper.populateAllMethods(cls.getSuperclass(), methods);
        for (Method method : SecurityActions.getDeclaredMethods(cls)) {
            methods.add(method);
        }
    }

    public static boolean isOverridden(Class<?> icptr, Method method) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        try {
            Method bottomMethod = ClassHelper.getMethod(icptr, method.getName(), method.getParameterTypes());
            return bottomMethod.getDeclaringClass() != method.getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method[] getMethods(Class<?> klass, Class<?> returnType, Class<?> ... paramTypes) {
        Method[] allMethodsOfClass;
        LinkedHashSet<Method> methodsAcceptingParamTypes = new LinkedHashSet<Method>();
        for (Method method : allMethodsOfClass = ClassHelper.getAllMethods(klass)) {
            if (!method.getReturnType().equals(returnType) || method.getParameterTypes().length != paramTypes.length || !ClassHelper.checkParameters(method.getParameterTypes(), paramTypes)) continue;
            methodsAcceptingParamTypes.add(method);
        }
        return methodsAcceptingParamTypes.toArray(new Method[methodsAcceptingParamTypes.size()]);
    }

    public static boolean isOverridden(Method method, Method ... methods) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        for (Method someMethod : methods) {
            if (!method.getName().equals(someMethod.getName()) || method.getParameterTypes().length != someMethod.getParameterTypes().length || !ClassHelper.checkParameters(method.getParameterTypes(), someMethod.getParameterTypes()) || method.getDeclaringClass().equals(someMethod.getDeclaringClass()) || !method.getDeclaringClass().isAssignableFrom(someMethod.getDeclaringClass())) continue;
            return true;
        }
        return false;
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
    }
}

