/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.interceptor.InvocationContext;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;

public class LifecycleCallbackInterceptorMethodInterceptor
implements Interceptor {
    private static final Class<?>[] PARAMETER_TYPES = new Class[]{InvocationContext.class};
    private Object interceptor;
    private Method method;

    public LifecycleCallbackInterceptorMethodInterceptor(Object interceptor, Method lifecycleCallbackMethod) {
        assert (interceptor != null) : "interceptor is null";
        assert (lifecycleCallbackMethod != null) : "lifecycleCallbackMethod is null";
        assert (lifecycleCallbackMethod.getReturnType() == Void.TYPE) : "return type must be void " + lifecycleCallbackMethod;
        assert (Arrays.equals(lifecycleCallbackMethod.getParameterTypes(), PARAMETER_TYPES)) : "wrong parameter signature";
        this.interceptor = interceptor;
        this.method = lifecycleCallbackMethod;
    }

    public String getName() {
        return "InvokeCallbackInterceptorMethodInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        InvocationContextInterceptor.InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        try {
            Object[] args = new Object[]{ctx};
            boolean accessible = this.method.isAccessible();
            this.method.setAccessible(true);
            try {
                this.method.invoke(this.interceptor, args);
            }
            finally {
                this.method.setAccessible(accessible);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

