/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.interceptor.InvocationContext;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;
import org.jboss.ejb3.interceptors.container.ContainerMethodInvocation;

public class EJB3InterceptorInterceptor
implements Interceptor {
    private static final Class<?>[] PARAMETER_TYPES = new Class[]{InvocationContext.class};
    private Class<?> interceptorClass;
    private Method method;

    public EJB3InterceptorInterceptor(Class<?> interceptorClass, Method businessMethodInterceptorMethod) {
        assert (interceptorClass != null) : "interceptorClass is null";
        assert (businessMethodInterceptorMethod != null) : "businessMethodInterceptorMethod is null";
        assert (businessMethodInterceptorMethod.getDeclaringClass().isAssignableFrom(interceptorClass)) : businessMethodInterceptorMethod + " does not belong to " + interceptorClass;
        assert (businessMethodInterceptorMethod.getReturnType() == Object.class) : "return type must be Object " + businessMethodInterceptorMethod;
        assert (Arrays.equals(businessMethodInterceptorMethod.getParameterTypes(), PARAMETER_TYPES)) : "wrong parameter signature";
        this.interceptorClass = interceptorClass;
        this.method = businessMethodInterceptorMethod;
        this.method.setAccessible(true);
    }

    public String getName() {
        return EJB3InterceptorInterceptor.class.getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object interceptor = ContainerMethodInvocation.getContainerMethodInvocation(invocation).getBeanContext().getInterceptor(this.interceptorClass);
        return this.invoke(interceptor, invocation);
    }

    private Object invoke(Object interceptor, Invocation invocation) throws Throwable {
        InvocationContextInterceptor.InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        try {
            Object[] args = new Object[]{ctx};
            return this.method.invoke(interceptor, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

