/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.debug.jsf;

import com.sun.faces.spi.SerializationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.HashSet;
import org.jboss.seam.Component;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class SeamDebugSerializationProvider
implements SerializationProvider {
    public ObjectInputStream createObjectInputStream(InputStream source) throws IOException {
        return new SeamObjectInputStream(source);
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream destination) throws IOException {
        return new ObjectOutputStream(destination);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SeamObjectInputStream
    extends ObjectInputStream {
        private static final LogProvider log = Logging.getLogProvider(SeamObjectInputStream.class);

        public SeamObjectInputStream(InputStream source) throws IOException {
            super(source);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                Class found = this.lookupInHotDeployLoaders(className);
                if (found != null) {
                    return found;
                }
                throw e;
            }
        }

        private Class lookupInHotDeployLoaders(String className) {
            log.debug((Object)("need to check hotdeploy classloaders to resolve " + className));
            HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
            for (String name : Init.instance().getHotDeployableComponents()) {
                Class c;
                ClassLoader loader = this.loaderForComponent(name);
                if (!loaders.add(loader) || (c = this.tryToLoadClass(loader, className)) == null) continue;
                return c;
            }
            return null;
        }

        private Class tryToLoadClass(ClassLoader loader, String className) {
            try {
                return loader.loadClass(className);
            }
            catch (Exception e) {
                log.debug((Object)("class not found in loader" + loader));
                return null;
            }
        }

        private ClassLoader loaderForComponent(String name) {
            Component component = (Component)Component.getInstance((String)(name + ".component"));
            if (component == null) {
                log.debug((Object)("Couldn't find component for " + name));
                return null;
            }
            return component.getBeanClass().getClassLoader();
        }
    }
}

