/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.resolve.naming;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.injection.resolve.naming.ResolutionException;
import org.jboss.injection.resolve.naming.ResultOnlyReferenceValidator;
import org.jboss.injection.resolve.spi.DuplicateReferenceValidator;
import org.jboss.injection.resolve.spi.EnvironmentMetaDataVisitor;
import org.jboss.injection.resolve.spi.Resolver;
import org.jboss.injection.resolve.spi.ResolverResult;
import org.jboss.metadata.javaee.spec.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentProcessor<C> {
    private Map<Class<?>, Resolver<?, C, ?>> resolvers;
    private List<EnvironmentMetaDataVisitor<?>> visitors;
    private Map<Class<?>, DuplicateReferenceValidator<?>> duplicateReferenceValidators;

    public EnvironmentProcessor() {
        this(new LinkedList(), new HashMap(), new HashMap());
    }

    public EnvironmentProcessor(List<EnvironmentMetaDataVisitor<?>> visitors, Map<Class<?>, Resolver<?, C, ?>> resolvers, Map<Class<?>, DuplicateReferenceValidator<?>> validators) {
        this.visitors = visitors;
        this.resolvers = resolvers;
        this.duplicateReferenceValidators = validators;
    }

    public List<ResolverResult<?>> process(C context, Environment ... environments) throws ResolutionException {
        return this.process(context, Arrays.asList(environments));
    }

    public List<ResolverResult<?>> process(C context, Iterable<Environment> environments) throws ResolutionException {
        MappedResults mappedresults = new MappedResults();
        for (Environment environment : environments) {
            for (EnvironmentMetaDataVisitor<?> visitor : this.visitors) {
                this.process(context, environment, visitor, mappedresults);
            }
        }
        return mappedresults.results;
    }

    protected <M> void process(C context, Environment environment, EnvironmentMetaDataVisitor<M> visitor, MappedResults mappedresults) throws ResolutionException {
        Iterable references = visitor.getMetaData(environment);
        if (references == null) {
            return;
        }
        for (Object reference : references) {
            this.process(context, reference, visitor.getMetaDataType(), mappedresults);
        }
    }

    protected <M> void process(C context, M reference, Class<M> referenceType, MappedResults mappedresults) throws ResolutionException {
        if (reference == null) {
            return;
        }
        Resolver<M, C, ?> resolver = this.getResolver(referenceType);
        if (resolver == null) {
            throw new ResolutionException("Found reference [" + reference + "] but no Resolver could be found for type [" + referenceType + "]");
        }
        ResolverResult result = resolver.resolve(context, reference);
        if (result == null) {
            throw new ResolutionException("Found reference [" + reference + "] but resolution failed to produce a result");
        }
        mappedresults.add(referenceType, reference, result);
    }

    protected <M, C> Resolver<M, C, ?> getResolver(Class<M> metaDataType) {
        return this.resolvers.get(metaDataType);
    }

    public void addMetaDataVisitor(EnvironmentMetaDataVisitor<?> visitor) {
        this.visitors.add(visitor);
    }

    public <M> void addResolver(Resolver<M, C, ?> resolver) {
        Class metaDataType = resolver.getMetaDataType();
        this.resolvers.put(metaDataType, resolver);
    }

    public <M> void addDuplicateReferenceValidator(DuplicateReferenceValidator<M> duplicateReferenceValidator) {
        Class metaDataType = duplicateReferenceValidator.getMetaDataType();
        this.duplicateReferenceValidators.put(metaDataType, duplicateReferenceValidator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MappedResults {
        private final Map<String, DuplicateReferenceValidator.ReferenceResultPair<?>> referenceMap = new HashMap();
        private final List<ResolverResult<?>> results = new LinkedList();

        private MappedResults() {
        }

        public <M> void add(Class<M> referenceType, M newReference, ResolverResult result) throws ResolutionException {
            DuplicateReferenceValidator.ReferenceResultPair newReferenceResult = new DuplicateReferenceValidator.ReferenceResultPair(newReference, result);
            DuplicateReferenceValidator.ReferenceResultPair previousReferenceResult = this.referenceMap.put(result.getRefName(), newReferenceResult);
            if (previousReferenceResult == null) {
                this.results.add(result);
            } else {
                this.checkForConflict(referenceType, previousReferenceResult, newReferenceResult);
            }
        }

        private <M> void checkForConflict(Class<M> referenceType, DuplicateReferenceValidator.ReferenceResultPair<?> previousReferencePair, DuplicateReferenceValidator.ReferenceResultPair<M> newReferencePair) throws ResolutionException {
            String envReferenceName = previousReferencePair.getResolverResult().getRefName();
            if (!previousReferencePair.getReference().getClass().isAssignableFrom(referenceType)) {
                throw new ResolutionException("Conflicting references found during resolution.  The references [" + previousReferencePair.getReference() + ", " + newReferencePair.getReference() + "] resolve to the same JNDI name [" + envReferenceName + "] and are not of the same reference type.");
            }
            DuplicateReferenceValidator.ReferenceResultPair<?> typedPreviousReferencePair = previousReferencePair;
            ResultOnlyReferenceValidator<M> duplicateReferenceValidator = (ResultOnlyReferenceValidator<M>)((Object)EnvironmentProcessor.this.duplicateReferenceValidators.get(referenceType));
            if (duplicateReferenceValidator == null) {
                duplicateReferenceValidator = new ResultOnlyReferenceValidator<M>(referenceType);
            }
            if (!duplicateReferenceValidator.isValid(typedPreviousReferencePair, newReferencePair)) {
                throw new ResolutionException("Conflicting environment entries were found during resolution.  The references [" + previousReferencePair.getReference() + ", " + newReferencePair.getReference() + "] resolve to the same JNDI name " + envReferenceName + "] and were not found to result in the same environment entry value.");
            }
        }
    }
}

