/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.NodeImpl;
import org.hibernate.validator.engine.PathImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private final List<MessageAndPath> messageAndPaths = new ArrayList<MessageAndPath>(3);
    private final PathImpl propertyPath;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(PathImpl propertyPath, ConstraintDescriptor<?> constraintDescriptor) {
        this.propertyPath = propertyPath;
        this.constraintDescriptor = constraintDescriptor;
    }

    public void disableDefaultConstraintViolation() {
        this.defaultDisabled = true;
    }

    public String getDefaultConstraintMessageTemplate() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ErrorBuilderImpl(messageTemplate, this.propertyPath);
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public List<MessageAndPath> getMessageAndPathList() {
        if (this.defaultDisabled && this.messageAndPaths.size() == 0) {
            throw new ValidationException("At least one custom message must be created if the default error message gets disabled.");
        }
        ArrayList<MessageAndPath> returnedMessageAndPaths = new ArrayList<MessageAndPath>(this.messageAndPaths);
        if (!this.defaultDisabled) {
            returnedMessageAndPaths.add(new MessageAndPath(this.getDefaultConstraintMessageTemplate(), this.propertyPath));
        }
        return returnedMessageAndPaths;
    }

    class InIterablePropertiesBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder {
        String messageTemplate;
        PathImpl propertyPath;
        String deferredNodeName;

        InIterablePropertiesBuilderImpl(String template, PathImpl path, String deferredNodeName) {
            this.messageTemplate = template;
            this.propertyPath = path;
            this.deferredNodeName = deferredNodeName;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atKey(Object key) {
            this.propertyPath.getLeafNode().setKey(key);
            this.addDeferredNode();
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atIndex(Integer index) {
            this.propertyPath.getLeafNode().setIndex(index);
            this.addDeferredNode();
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            this.addDeferredNode();
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath, name);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            this.addDeferredNode();
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }

        private void addDeferredNode() {
            if (this.deferredNodeName != null) {
                NodeImpl node = new NodeImpl(this.deferredNodeName);
                this.propertyPath.addNode(node);
            }
        }
    }

    class InIterableNodeBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext {
        String messageTemplate;
        PathImpl propertyPath;
        String deferredNodeName;

        InIterableNodeBuilderImpl(String template, PathImpl path, String deferredNodeName) {
            this.messageTemplate = template;
            this.propertyPath = path;
            this.deferredNodeName = deferredNodeName;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder inIterable() {
            this.propertyPath.getLeafNode().setInIterable(true);
            return new InIterablePropertiesBuilderImpl(this.messageTemplate, this.propertyPath, this.deferredNodeName);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            this.addDeferredNode();
            this.deferredNodeName = name;
            return this;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            this.addDeferredNode();
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }

        private void addDeferredNode() {
            if (this.deferredNodeName != null) {
                NodeImpl node = new NodeImpl(this.deferredNodeName);
                this.propertyPath.addNode(node);
            }
        }
    }

    class NodeBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext {
        String messageTemplate;
        PathImpl propertyPath;

        NodeBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath, name);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class ErrorBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        String messageTemplate;
        PathImpl propertyPath;

        ErrorBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            PathImpl path;
            if (this.propertyPath.isRootPath()) {
                path = PathImpl.createNewPath(name);
            } else {
                path = PathImpl.createShallowCopy(this.propertyPath);
                path.addNode(new NodeImpl(name));
            }
            return new NodeBuilderImpl(this.messageTemplate, path);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }
}

