/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.constraints.impl.scriptassert.ScriptEvaluator;
import org.hibernate.validator.constraints.impl.scriptassert.ScriptEvaluatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptAssertValidator
implements ConstraintValidator<ScriptAssert, Object> {
    private String script;
    private String languageName;
    private String alias;

    public void initialize(ScriptAssert constraintAnnotation) {
        this.validateParameters(constraintAnnotation);
        this.script = constraintAnnotation.script();
        this.languageName = constraintAnnotation.lang();
        this.alias = constraintAnnotation.alias();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        ScriptEvaluator scriptEvaluator = ScriptEvaluatorFactory.getInstance().getScriptEvaluatorByLanguageName(this.languageName);
        return scriptEvaluator.evaluate(this.script, value, this.alias);
    }

    private void validateParameters(ScriptAssert constraintAnnotation) {
        if (constraintAnnotation.script().isEmpty()) {
            throw new IllegalArgumentException("The parameter \"script\" must not be empty.");
        }
        if (constraintAnnotation.lang().isEmpty()) {
            throw new IllegalArgumentException("The parameter \"lang\" must not be empty.");
        }
        if (constraintAnnotation.alias().isEmpty()) {
            throw new IllegalArgumentException("The parameter \"alias\" must not be empty.");
        }
    }
}

