/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.spi.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanningPluginWrapper<T extends ScanningHandle, U>
implements ScanningPlugin<T, U> {
    private ScanningPlugin<T, U> delegate;
    private List<String> excudedPaths = CollectionsFactory.createLazyList();

    public ScanningPluginWrapper(ScanningPlugin<T, U> delegate) {
        this.delegate = delegate;
    }

    void addURL(URL url) {
        this.excudedPaths.add(url.getPath());
    }

    @Override
    public T createHandle() {
        return this.delegate.createHandle();
    }

    @Override
    public ScanningHandle readHandle(InputStream is) throws Exception {
        return this.delegate.readHandle(is);
    }

    @Override
    public void writeHandle(OutputStream os, T handle) throws IOException {
        this.delegate.writeHandle(os, handle);
    }

    @Override
    public void cleanupHandle(U handle) {
        this.delegate.cleanupHandle(handle);
    }

    @Override
    public Class<U> getHandleInterface() {
        return this.delegate.getHandleInterface();
    }

    @Override
    public String getAttachmentKey() {
        return this.delegate.getAttachmentKey();
    }

    @Override
    public String getFileName() {
        return this.delegate.getFileName();
    }

    @Override
    public ResourceFilter getRecurseFilter() {
        if (this.excudedPaths.isEmpty()) {
            return this.delegate.getRecurseFilter();
        }
        return new ExcludedPathsFilter();
    }

    public boolean accepts(ResourceContext resource) {
        return this.delegate.accepts(resource);
    }

    public ResourceFilter getFilter() {
        return this.delegate.getFilter();
    }

    public void visit(ResourceContext resource) {
        this.delegate.visit(resource);
    }

    private class ExcludedPathsFilter
    implements ResourceFilter {
        private ExcludedPathsFilter() {
        }

        public boolean accepts(ResourceContext resource) {
            URL url = resource.getUrl();
            String urlString = url.toString();
            for (String exceluded : ScanningPluginWrapper.this.excudedPaths) {
                if (!urlString.contains(exceluded)) continue;
                return false;
            }
            return ScanningPluginWrapper.this.delegate.accepts(resource);
        }
    }
}

