/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class WSTypeDeployer
extends AbstractRealDeployer {
    public WSTypeDeployer() {
        this.addInput(JBossWebMetaData.class);
        this.addInput(WebservicesMetaData.class);
        this.addInput(WebServiceDeployment.class);
        this.addOutput(Deployment.DeploymentType.class);
        this.addOutput(JBossWebMetaData.class);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (this.isJaxwsJseDeployment(unit)) {
            this.log.debug((Object)"Detected JAXWS JSE deployment");
            unit.addAttachment(Deployment.DeploymentType.class, (Object)Deployment.DeploymentType.JAXWS_JSE);
        } else if (this.isJaxwsEjbDeployment(unit)) {
            this.log.debug((Object)"Detected JAXWS EJB3 deployment");
            unit.addAttachment(Deployment.DeploymentType.class, (Object)Deployment.DeploymentType.JAXWS_EJB3);
        } else if (this.isJaxrpcJseDeployment(unit)) {
            this.log.debug((Object)"Detected JAXRPC JSE deployment");
            unit.addAttachment(Deployment.DeploymentType.class, (Object)Deployment.DeploymentType.JAXRPC_JSE);
        } else if (this.isJaxrpcEjbDeployment(unit)) {
            this.log.debug((Object)"Detected JAXRPC EJB21 deployment");
            unit.addAttachment(Deployment.DeploymentType.class, (Object)Deployment.DeploymentType.JAXRPC_EJB21);
        } else if (this.isJaxwsJmsDeployment(unit)) {
            this.log.debug((Object)"Detected JAXWS JMS deployment");
            unit.addAttachment(Deployment.DeploymentType.class, (Object)Deployment.DeploymentType.JAXWS_JMS);
        }
    }

    private boolean isJaxrpcEjbDeployment(DeploymentUnit unit) {
        boolean hasWebservicesMD = ASHelper.hasAttachment(unit, WebservicesMetaData.class);
        boolean hasJBossMD = unit.getAllMetaData(JBossMetaData.class).size() > 0;
        return hasWebservicesMD && hasJBossMD;
    }

    private boolean isJaxrpcJseDeployment(DeploymentUnit unit) {
        boolean hasWebservicesMD = ASHelper.hasAttachment(unit, WebservicesMetaData.class);
        boolean hasJBossWebMD = ASHelper.hasAttachment(unit, JBossWebMetaData.class);
        if (hasWebservicesMD && hasJBossWebMD) {
            return ASHelper.getJaxrpcServlets(unit).size() > 0;
        }
        return false;
    }

    private boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        boolean hasWSDeployment = ASHelper.hasAttachment(unit, WebServiceDeployment.class);
        if (hasWSDeployment) {
            return ASHelper.getJaxwsEjbs(unit).size() > 0;
        }
        return false;
    }

    private boolean isJaxwsJseDeployment(DeploymentUnit unit) {
        boolean hasJBossWebMD = ASHelper.hasAttachment(unit, JBossWebMetaData.class);
        if (hasJBossWebMD) {
            return ASHelper.getJaxwsServlets(unit).size() > 0;
        }
        return false;
    }

    private boolean isJaxwsJmsDeployment(DeploymentUnit unit) {
        return ASHelper.hasAttachment(unit, JMSEndpointsMetaData.class);
    }
}

