/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.profileservice.Hack;
import org.jboss.profileservice.repository.artifact.file.FileArtifact;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.repository.artifact.file.FileRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.Artifact;
import org.jboss.profileservice.spi.repository.artifact.ArtifactFilter;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.PathTokenizer;

public class LocalFileArtifactRepository
implements ArtifactRepository<FileArtifactId>,
Closeable {
    private final ArtifactRepositoryId identifier;
    private final URI repositoryURI;
    private final FileRepositoryConfiguration configuration;
    private VirtualFile repositoryRoot;
    private Closeable mount;

    public LocalFileArtifactRepository(ArtifactRepositoryId identifier, URI repositoryURI, FileRepositoryConfiguration configuration) {
        if (identifier == null) {
            throw new IllegalArgumentException("null repository id");
        }
        if (repositoryURI == null) {
            throw new IllegalArgumentException("null repository uri");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("null repository configuration");
        }
        this.identifier = identifier;
        this.repositoryURI = repositoryURI;
        this.configuration = configuration;
    }

    public void create() throws IOException {
        VirtualFile originalLocation = VFS.getChild((URI)this.getRepositoryURI());
        if (!originalLocation.exists() && this.getConfiguration().isCreateIfDoesNotExists() && !originalLocation.getPhysicalFile().mkdirs()) {
            throw new IOException("failed to create " + this.getRepositoryURI());
        }
        if (!originalLocation.isDirectory() && !Hack.ignoreHack()) {
            throw new IOException(originalLocation + " is not a directory");
        }
        if (this.getConfiguration().getBackupPolicy() == ArtifactRepositoryConfiguration.VFSBackupPolicy.BACKUP) {
            if (this.getConfiguration().getBackupURI() == null) {
                throw new IllegalStateException("null backup uri");
            }
            VirtualFile backupLocation = VFS.getChild((URI)this.getConfiguration().getBackupURI());
            this.mount = VFS.mountReal((File)originalLocation.getPhysicalFile(), (VirtualFile)backupLocation);
            this.repositoryRoot = backupLocation;
        } else {
            this.repositoryRoot = originalLocation;
        }
    }

    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
        VFSUtils.safeClose((Closeable)this.mount);
    }

    public FileRepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public ArtifactRepositoryId getIdentifier() {
        return this.identifier;
    }

    public URI getRepositoryURI() {
        return this.repositoryURI;
    }

    public boolean containsArtifact(FileArtifactId artifact) {
        this.validateArtifactID(artifact);
        return this.getRepositoryRoot().getChild(artifact.getPath()).exists();
    }

    public FileArtifact getArtifact(FileArtifactId artifactId) {
        this.validateArtifactID(artifactId);
        return new FileArtifact(artifactId, this);
    }

    public Collection<Artifact<FileArtifactId>> getArtifacts() {
        ArrayList<Artifact<FileArtifactId>> artifacts = new ArrayList<Artifact<FileArtifactId>>();
        this.getArtifacts(this.getRepositoryRoot(), artifacts, true);
        return artifacts;
    }

    public Collection<Artifact<FileArtifactId>> getArtifacts(ArtifactFilter<FileArtifactId> filter) {
        ArrayList<Artifact<FileArtifactId>> artifacts = new ArrayList<Artifact<FileArtifactId>>();
        this.getArtifacts(this.getRepositoryRoot(), artifacts, filter);
        return artifacts;
    }

    protected void getArtifacts(VirtualFile vf, List<Artifact<FileArtifactId>> artifacts, final boolean recurse) {
        this.getArtifacts(vf, artifacts, new ArtifactFilter<FileArtifactId>(){

            public boolean accepts(Artifact<FileArtifactId> artifact) {
                return true;
            }

            public boolean recurse(Artifact<FileArtifactId> artifact) {
                return recurse;
            }
        });
    }

    protected void getArtifacts(VirtualFile vf, List<Artifact<FileArtifactId>> artifacts, ArtifactFilter<FileArtifactId> artifactFilter) {
        for (VirtualFile child : vf.getChildren()) {
            if (!this.getConfiguration().getExcludeFilter().accepts(child)) continue;
            String path = child.getPathNameRelativeTo(this.getRepositoryRoot());
            FileArtifact artifact = new FileArtifact(new FileArtifactId(path), this);
            if (artifactFilter.accepts((Artifact)artifact)) {
                artifacts.add(artifact);
            }
            if (!child.isDirectory() || !artifactFilter.recurse((Artifact)artifact)) continue;
            this.getArtifacts(child, artifacts, artifactFilter);
        }
    }

    public VirtualFile getArtifactFile(FileArtifactId artifact) throws IOException {
        return this.getArtifactFile(artifact, true);
    }

    public VirtualFile getOriginalFile(FileArtifactId artifactId) throws IOException {
        if (!this.getArtifactFile(artifactId, false).exists()) {
            this.getConfiguration().getNotFoundHandler().handleArtifactNotFound((ArtifactRepository)this, (ArtifactId)artifactId);
        }
        if (this.getConfiguration().getBackupPolicy() == ArtifactRepositoryConfiguration.VFSBackupPolicy.BACKUP) {
            VirtualFile repositoryRoot = VFS.getChild((URI)this.getRepositoryURI());
            FileArtifact artifact = this.getArtifact(artifactId);
            return repositoryRoot.getChild(artifact.getRelativePath());
        }
        return this.getArtifactFile(artifactId, true);
    }

    protected VirtualFile getArtifactFile(FileArtifactId artifactId, boolean checkExist) throws IOException {
        this.validateArtifactID(artifactId);
        VirtualFile vf = this.getRepositoryRoot().getChild(artifactId.getPath());
        if (checkExist && !vf.exists()) {
            this.getConfiguration().getNotFoundHandler().handleArtifactNotFound((ArtifactRepository)this, (ArtifactId)artifactId);
        }
        return vf;
    }

    protected void validateArtifactID(FileArtifactId artifactId) {
        if (artifactId == null) {
            throw new IllegalStateException("null artifact id");
        }
        String pathString = artifactId.getPath();
        List tokens = PathTokenizer.getTokens((String)pathString);
        for (String token : tokens) {
            if (!PathTokenizer.isCurrentToken((String)token) && !PathTokenizer.isReverseToken((String)token)) continue;
            throw new IllegalStateException("Illegal artifact path, no current/reverse tokens allowed " + pathString);
        }
    }

    protected VirtualFile getRepositoryRoot() {
        return this.repositoryRoot;
    }
}

