/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.repository.artifact.file.FileRepositoryConfiguration;
import org.jboss.profileservice.repository.artifact.file.LocalFileArtifactRepository;
import org.jboss.profileservice.repository.artifact.file.MutableFileArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactNotFoundHandler;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryFactory;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class FileArtifactRepositoryFactory
implements ArtifactRepositoryFactory<FileArtifactId> {
    private final VirtualFile root;
    private final ProfileServiceConfig config;

    public FileArtifactRepositoryFactory(URI rootURI, ProfileServiceConfig config) throws IOException {
        this.root = VFS.getChild((URI)rootURI);
        this.config = config;
    }

    public String getRepositoryType() {
        return FileArtifactId.TYPE;
    }

    protected VirtualFile getRoot() {
        return this.root;
    }

    public void start() {
        if (!this.getRoot().exists()) {
            throw new IllegalStateException("non existing repository root " + this.getRoot().getPathName());
        }
    }

    public ArtifactRepository<FileArtifactId> createArtifactRepository(ArtifactRepositoryId repositoryId, ArtifactRepositoryConfiguration<FileArtifactId> configuration) throws IOException {
        if (repositoryId == null) {
            throw new IllegalArgumentException("null repository id");
        }
        LocalFileArtifactRepository repository = null;
        try {
            String name = repositoryId.getName();
            FileRepositoryConfiguration config = this.createConfiguration(configuration);
            URI location = config.getOverrideURI();
            if (location == null) {
                VirtualFile vf = this.getRoot().getChild(name);
                location = vf.asDirectoryURI();
            }
            repository = config.isMutable() ? new MutableFileArtifactRepository(repositoryId, location, config) : new LocalFileArtifactRepository(repositoryId, location, config);
            repository.create();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("failed to create file artifact repository ", e);
        }
        return repository;
    }

    protected FileRepositoryConfiguration createConfiguration(ArtifactRepositoryConfiguration<FileArtifactId> predefined) throws URISyntaxException {
        FileRepositoryConfiguration configuration = this.createDefaultConfiguration();
        if (predefined != null) {
            configuration.setMutable(predefined.isMutable());
            if (predefined.getBackupPolicy() != null) {
                configuration.setBackupPolicy(predefined.getBackupPolicy());
            }
            if (predefined.getNotFoundHandler() != null) {
                configuration.setNotFoundHandler((ArtifactNotFoundHandler<FileArtifactId>)predefined.getNotFoundHandler());
            }
            if (predefined instanceof FileRepositoryConfiguration) {
                FileRepositoryConfiguration other = (FileRepositoryConfiguration)FileRepositoryConfiguration.class.cast(predefined);
                if (other.getOverrideURI() != null) {
                    configuration.setOverrideURI(other.getOverrideURI());
                }
                if (other.isMutable()) {
                    if (other.getBackupURI() != null) {
                        configuration.setBackupURI(other.getBackupURI());
                    } else {
                        configuration.setBackupURI(this.config.getRepositoriesConfiguration().createBackupURI());
                    }
                }
                if (other.getMountOverrides() != null) {
                    configuration.setMountOverrides(other.getMountOverrides());
                }
            }
        }
        return configuration;
    }

    protected FileRepositoryConfiguration createDefaultConfiguration() {
        FileRepositoryConfiguration configuration = new FileRepositoryConfiguration();
        configuration.setExcludeFilter(this.config.getRepositoriesConfiguration().getExcludeFilter());
        return configuration;
    }
}

