/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryFactory;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VFSUtils;

public class ArtifactRepositoryManager
implements ArtifactRepositoryFactory<ArtifactId> {
    private static final String DEFAULT_NAME = "###DEFAULT####";
    private Map<String, ArtifactRepositoryFactory<ArtifactId>> factories = new ConcurrentHashMap<String, ArtifactRepositoryFactory<ArtifactId>>();
    private ConcurrentMap<ArtifactRepositoryId, ArtifactRepository<ArtifactId>> repositories = new ConcurrentHashMap<ArtifactRepositoryId, ArtifactRepository<ArtifactId>>();
    private ConcurrentMap<ArtifactRepositoryId, AtomicInteger> repositoryTacking = new ConcurrentHashMap<ArtifactRepositoryId, AtomicInteger>();

    public Collection<ArtifactRepository<ArtifactId>> getRepositories() {
        return new ArrayList<ArtifactRepository<ArtifactId>>(this.repositories.values());
    }

    public ArtifactRepository<ArtifactId> getArtifactRepository(ArtifactRepositoryId repositoryId) {
        ArtifactRepository repository = (ArtifactRepository)this.repositories.get(repositoryId);
        if (repository == null) {
            throw new IllegalStateException("failed to find artifact repository for id " + repositoryId);
        }
        return repository;
    }

    public ArtifactRepository<ArtifactId> createArtifactRepository(ArtifactRepositoryId repositoryId, ArtifactRepositoryConfiguration<ArtifactId> configuration) throws IOException {
        if (repositoryId == null) {
            throw new IllegalArgumentException("null repository id");
        }
        ArtifactRepository repository = (ArtifactRepository)this.repositories.get(repositoryId);
        if (repository == null) {
            String repositoryType = repositoryId.getType();
            if (repositoryType == null) {
                throw new IllegalArgumentException("null repository type");
            }
            ArtifactRepositoryFactory<ArtifactId> factory = this.factories.get(repositoryType);
            if (factory == null) {
                throw new IllegalStateException("no registered factory for type " + repositoryType);
            }
            repository = factory.createArtifactRepository(repositoryId, configuration);
            if (repository == null) {
                throw new IllegalArgumentException("created null artifact repository " + repositoryId);
            }
            this.addRepository((ArtifactRepository<ArtifactId>)repository);
        }
        this.incrementUsage(repositoryId);
        return repository;
    }

    public String getRepositoryType() {
        return DEFAULT_NAME;
    }

    public void addRepository(ArtifactRepository<ArtifactId> repository) {
        if (repository == null) {
            throw new IllegalArgumentException("null repository");
        }
        if (repository.getIdentifier() == null) {
            throw new IllegalArgumentException("null repository configuration");
        }
        ArtifactRepository<ArtifactId> other = this.repositories.putIfAbsent((ArtifactRepositoryId)repository.getIdentifier(), repository);
        if (other != null) {
            throw new IllegalStateException("duplicate repository " + repository);
        }
    }

    public void removeRepository(ArtifactRepository<ArtifactId> repository) {
        if (repository == null) {
            throw new IllegalArgumentException("null repository");
        }
        if (repository.getIdentifier() == null) {
            throw new IllegalArgumentException("null repository configuration");
        }
        this.repositories.remove(repository.getIdentifier());
    }

    public void removeRepository(ArtifactRepositoryId repositoryId) {
        ArtifactRepository repository;
        if (this.decrementUsage(repositoryId) == 0 && (repository = (ArtifactRepository)this.repositories.remove(repositoryId)) instanceof Closeable) {
            VFSUtils.safeClose((Closeable)((Closeable)Closeable.class.cast(repository)));
        }
    }

    public void addRepositoryFactory(ArtifactRepositoryFactory<ArtifactId> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        if (factory.getRepositoryType() == null) {
            throw new IllegalArgumentException("null factory type");
        }
        this.factories.put(factory.getRepositoryType(), factory);
    }

    public void removeRepositoryFactory(ArtifactRepositoryFactory<ArtifactId> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        if (factory.getRepositoryType() == null) {
            throw new IllegalArgumentException("null factory type");
        }
        this.factories.remove(factory.getRepositoryType());
        if (factory instanceof Closeable) {
            VFSUtils.safeClose((Closeable)((Closeable)Closeable.class.cast(factory)));
        }
    }

    protected void incrementUsage(ArtifactRepositoryId id) {
        this.repositoryTacking.putIfAbsent(id, new AtomicInteger(0));
        ((AtomicInteger)this.repositoryTacking.get(id)).incrementAndGet();
    }

    protected int decrementUsage(ArtifactRepositoryId id) {
        AtomicInteger i = (AtomicInteger)this.repositoryTacking.get(id);
        if (i != null) {
            return i.decrementAndGet();
        }
        return -1;
    }
}

