/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact;

import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;

public class AbstractRepositoryId
implements ArtifactRepositoryId {
    private static final long serialVersionUID = 6983571857334117945L;
    private final String name;
    private final String type;
    private final int hashCode;

    public AbstractRepositoryId(String name, String type) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.name = name;
        this.type = type;
        this.hashCode = this.createHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int createHashCode() {
        int result = 17;
        result += 31 * this.name.hashCode();
        return result += 31 * this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ArtifactRepositoryId)) {
            return false;
        }
        ArtifactRepositoryId other = (ArtifactRepositoryId)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        return this.type.equals(other.getType());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append('{');
        buffer.append("name=").append(this.name);
        buffer.append(", type=").append(this.type);
        buffer.append('}');
        return buffer.toString();
    }
}

