/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import org.jboss.shrinkwrap.api.asset.Asset;

public class UrlAsset
implements Asset {
    private URL url;

    public UrlAsset(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must be specified");
        }
        this.url = url;
    }

    public InputStream openStream() {
        try {
            return new BufferedInputStream(this.url.openStream(), 8192);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open stream for url " + this.url.toExternalForm(), e);
        }
    }

    public String toString() {
        return UrlAsset.class.getSimpleName() + " [url=" + this.url.toExternalForm() + "]";
    }
}

