/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.logging.Logger;
import org.jboss.security.microcontainer.beans.ACLPolicyBean;
import org.jboss.security.microcontainer.beans.ApplicationPolicyBean;
import org.jboss.security.microcontainer.beans.AuditPolicyBean;
import org.jboss.security.microcontainer.beans.AuthenticationPolicyBean;
import org.jboss.security.microcontainer.beans.AuthorizationPolicyBean;
import org.jboss.security.microcontainer.beans.IdentityTrustPolicyBean;
import org.jboss.security.microcontainer.beans.JASPIAuthenticationPolicyBean;
import org.jboss.security.microcontainer.beans.MappingPolicyBean;
import org.jboss.security.microcontainer.beans.metadata.ACLMetaData;
import org.jboss.security.microcontainer.beans.metadata.AuditMetaData;
import org.jboss.security.microcontainer.beans.metadata.AuthenticationMetaData;
import org.jboss.security.microcontainer.beans.metadata.AuthorizationMetaData;
import org.jboss.security.microcontainer.beans.metadata.IdentityTrustMetaData;
import org.jboss.security.microcontainer.beans.metadata.JASPIAuthenticationMetaData;
import org.jboss.security.microcontainer.beans.metadata.MappingMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBossXmlSchema(namespace="urn:jboss:security-beans:1.0", elementFormDefault=XmlNsForm.QUALIFIED)
@XmlRootElement(name="application-policy")
@XmlType(name="applicationPolicyType", propOrder={"authentication", "jaspiAuthentication", "authorization", "acl", "roleMapping", "mapping", "audit", "identityTrust"})
public class ApplicationPolicyMetaDataFactory
implements BeanMetaDataFactory {
    private static final String DEFAUL_SEC_MANAGEMENT = "JNDIBasedSecurityManagement";
    private String policyName;
    private String parentPolicy;
    private String securityManagement = "JNDIBasedSecurityManagement";
    private AuthenticationMetaData authMetaData;
    private JASPIAuthenticationMetaData jaspiMetaData;
    private AuthorizationMetaData authzMetaData;
    private ACLMetaData aclMetaData;
    private MappingMetaData roleMappingMetaData;
    private MappingMetaData mappingMetaData;
    private AuditMetaData auditMetaData;
    private IdentityTrustMetaData trustMetaData;
    protected static Logger logger = Logger.getLogger(ApplicationPolicyMetaDataFactory.class);

    @XmlAttribute(name="name", required=true)
    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    @XmlAttribute(name="extends")
    public void setParentPolicy(String parentPolicy) {
        this.parentPolicy = parentPolicy;
    }

    @XmlAttribute(name="securityManagement")
    public void setSecurityManagement(String securityManagement) {
        this.securityManagement = securityManagement;
    }

    @XmlElement(name="authentication", type=AuthenticationMetaData.class)
    public void setAuthentication(AuthenticationMetaData authMetaData) {
        if (this.jaspiMetaData != null) {
            throw new IllegalArgumentException("An <authentication-jaspi> configuration has already been defined for the policy");
        }
        this.authMetaData = authMetaData;
    }

    @XmlElement(name="authentication-jaspi", type=JASPIAuthenticationMetaData.class)
    public void setJaspiAuthentication(JASPIAuthenticationMetaData jaspiMetaData) {
        if (this.authMetaData != null) {
            throw new IllegalArgumentException("An <authentication> configuration has already been defined for the policy");
        }
        this.jaspiMetaData = jaspiMetaData;
    }

    @XmlElement(name="authorization", type=AuthorizationMetaData.class)
    public void setAuthorization(AuthorizationMetaData authzMetaData) {
        this.authzMetaData = authzMetaData;
    }

    @XmlElement(name="acl", type=ACLMetaData.class)
    public void setAcl(ACLMetaData aclMetaData) {
        this.aclMetaData = aclMetaData;
    }

    @XmlElement(name="rolemapping", type=MappingMetaData.class)
    public void setRoleMapping(MappingMetaData mappingMetaData) {
        this.roleMappingMetaData = mappingMetaData;
    }

    @XmlElement(name="mapping", type=MappingMetaData.class)
    public void setMapping(MappingMetaData mappingMetaData) {
        this.mappingMetaData = mappingMetaData;
    }

    @XmlElement(name="audit", type=AuditMetaData.class)
    public void setAudit(AuditMetaData auditMetaData) {
        this.auditMetaData = auditMetaData;
    }

    @XmlElement(name="identity-trust", type=IdentityTrustMetaData.class)
    public void setIdentityTrust(IdentityTrustMetaData trustMetaData) {
        this.trustMetaData = trustMetaData;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        ValueMetaData injectMappingPolicy;
        String mappingPolicyName;
        ValueMetaData injectAuthenticationPolicy;
        String authPolicyName;
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>();
        logger.trace((Object)("Generating metadata for application-policy " + this.policyName));
        BeanMetaDataBuilder policyBuilder = BeanMetaDataBuilder.createBuilder((String)this.policyName, (String)ApplicationPolicyBean.class.getName());
        policyBuilder.addPropertyMetaData("name", this.policyName);
        policyBuilder.addPropertyMetaData("parentPolicy", this.parentPolicy);
        result.add(policyBuilder.getBeanMetaData());
        if (this.authMetaData != null) {
            logger.trace((Object)("Generating authentication metadata for policy " + this.policyName));
            authPolicyName = this.policyName + "$AuthenticationPolicy";
            result.addAll(this.authMetaData.getBeans(authPolicyName, AuthenticationPolicyBean.class.getName()));
            injectAuthenticationPolicy = policyBuilder.createInject((Object)authPolicyName);
            policyBuilder.addPropertyMetaData("authenticationPolicy", injectAuthenticationPolicy);
        } else if (this.jaspiMetaData != null) {
            logger.trace((Object)("Generating jaspi-authentication metadata for policy " + this.policyName));
            authPolicyName = this.policyName + "$JASPIAuthenticationPolicy";
            result.addAll(this.jaspiMetaData.getBeans(authPolicyName, JASPIAuthenticationPolicyBean.class.getName()));
            injectAuthenticationPolicy = policyBuilder.createInject((Object)authPolicyName);
            policyBuilder.addPropertyMetaData("authenticationPolicy", injectAuthenticationPolicy);
        } else if (this.parentPolicy == null) {
            throw new RuntimeException("An application policy must have an authentication or authentication-jaspi configuration");
        }
        if (this.authzMetaData != null) {
            logger.trace((Object)("Generating authorization metadata for policy " + this.policyName));
            String authzPolicyName = this.policyName + "$AuthorizationPolicy";
            result.addAll(this.authzMetaData.getBeans(authzPolicyName, AuthorizationPolicyBean.class.getName()));
            ValueMetaData injectAuthorizationPolicy = policyBuilder.createInject((Object)authzPolicyName);
            policyBuilder.addPropertyMetaData("authorizationPolicy", injectAuthorizationPolicy);
        }
        if (this.aclMetaData != null) {
            logger.trace((Object)("Generating acl metadata for policy " + this.policyName));
            String aclPolicyName = this.policyName + "$ACLPolicy";
            result.addAll(this.aclMetaData.getBeans(aclPolicyName, ACLPolicyBean.class.getName()));
            ValueMetaData injectACLPolicy = policyBuilder.createInject((Object)aclPolicyName);
            policyBuilder.addPropertyMetaData("aclPolicy", injectACLPolicy);
        }
        if (this.roleMappingMetaData != null) {
            logger.trace((Object)("Generating role-mapping metadata for policy " + this.policyName));
            mappingPolicyName = this.policyName + "$RoleMappingPolicy";
            result.addAll(this.roleMappingMetaData.getBeans(mappingPolicyName, MappingPolicyBean.class.getName()));
            injectMappingPolicy = policyBuilder.createInject((Object)mappingPolicyName);
            policyBuilder.addPropertyMetaData("roleMappingPolicy", injectMappingPolicy);
        }
        if (this.mappingMetaData != null) {
            logger.trace((Object)("Generating mapping metadata for policy " + this.policyName));
            mappingPolicyName = this.policyName + "$MappingPolicy";
            result.addAll(this.mappingMetaData.getBeans(mappingPolicyName, MappingPolicyBean.class.getName()));
            injectMappingPolicy = policyBuilder.createInject((Object)mappingPolicyName);
            policyBuilder.addPropertyMetaData("mappingPolicy", injectMappingPolicy);
        }
        if (this.auditMetaData != null) {
            logger.trace((Object)("Generating audit metadata for policy " + this.policyName));
            String auditPolicyName = this.policyName + "$AuditPolicy";
            result.addAll(this.auditMetaData.getBeans(auditPolicyName, AuditPolicyBean.class.getName()));
            ValueMetaData injectAuditPolicy = policyBuilder.createInject((Object)auditPolicyName);
            policyBuilder.addPropertyMetaData("auditPolicy", injectAuditPolicy);
        }
        if (this.trustMetaData != null) {
            logger.trace((Object)("Generating identity-trust metadata for policy " + this.policyName));
            String trustPolicyName = this.policyName + "$IdentityTrustPolicy";
            result.addAll(this.trustMetaData.getBeans(trustPolicyName, IdentityTrustPolicyBean.class.getName()));
            ValueMetaData injectIdentityTrustPolicy = policyBuilder.createInject((Object)trustPolicyName);
            policyBuilder.addPropertyMetaData("identityTrustPolicy", injectIdentityTrustPolicy);
        }
        logger.trace((Object)("Injecting security management " + this.securityManagement + " into application-policy metadata"));
        ValueMetaData injectManagement = policyBuilder.createInject((Object)this.securityManagement);
        policyBuilder.addPropertyMetaData("securityManagement", injectManagement);
        return result;
    }
}

