/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.lifecycle.PhaseExecutor;

class RenderResponseExecutor
extends PhaseExecutor {
    private static final Logger log = Logger.getLogger(RenderResponseExecutor.class.getName());

    RenderResponseExecutor() {
    }

    public boolean execute(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        try {
            UIViewRoot root;
            String viewId;
            String newViewId;
            do {
                ViewDeclarationLanguage vdl;
                if ((vdl = viewHandler.getViewDeclarationLanguage(facesContext, viewId = (root = facesContext.getViewRoot()).getViewId())) != null) {
                    vdl.buildView(facesContext, root);
                }
                application.publishEvent(facesContext, PreRenderViewEvent.class, (Object)root);
                if (!facesContext.getResponseComplete()) continue;
                return false;
            } while ((newViewId = facesContext.getViewRoot().getViewId()) == null && viewId != null || newViewId != null && !newViewId.equals(viewId));
            viewHandler.renderView(facesContext, root);
            if (!facesContext.getMessageList().isEmpty()) {
                StringBuilder builder = new StringBuilder();
                boolean shouldLog = false;
                for (FacesMessage message : facesContext.getMessageList()) {
                    if (message.isRendered()) continue;
                    builder.append("\n- ");
                    builder.append(message.getDetail());
                    shouldLog = true;
                }
                if (shouldLog) {
                    log.log(Level.WARNING, "There are some unhandled FacesMessages, this means not every FacesMessage had a chance to be rendered.\nThese unhandled FacesMessages are: " + builder.toString());
                }
            }
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public PhaseId getPhase() {
        return PhaseId.RENDER_RESPONSE;
    }
}

