/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component._SelectItemsIterator;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _SharedRendererUtils {
    static final String COLLECTION_TYPE_KEY = "collectionType";

    _SharedRendererUtils() {
    }

    static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression expression = component.getValueExpression("value");
        if (expression == null) {
            return null;
        }
        Class valueType = expression.getType(facesContext.getELContext());
        if (valueType == null) {
            return null;
        }
        if (Object.class.equals((Object)valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            _SharedRendererUtils.log(facesContext, "No Converter for type " + valueType.getName() + " found", e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        void var4_18;
        Converter converter;
        block28: {
            if (submittedValue == null) {
                throw new NullPointerException("submittedValue");
            }
            ValueExpression expression = component.getValueExpression("value");
            Object var4_4 = null;
            converter = component.getConverter();
            if (expression != null) {
                Class<?> modelType = expression.getType(facesContext.getELContext());
                if (modelType == null) {
                    return submittedValue;
                }
                if (modelType.isArray()) {
                    Class<?> componentType = modelType.getComponentType();
                    if (String.class.equals(componentType)) {
                        return submittedValue;
                    }
                    if (converter == null && (converter = facesContext.getApplication().createConverter(componentType)) == null && !Object.class.equals(componentType)) {
                        throw new ConverterException("Could not obtain a Converter for " + componentType.getName());
                    }
                    Object object = Array.newInstance(componentType, submittedValue.length);
                } else {
                    if (!Collection.class.isAssignableFrom(modelType) && !Object.class.equals((Object)modelType)) throw new ConverterException("ValueExpression for UISelectMany must be of type Collection or Array.");
                    if (converter == null) {
                        _SelectItemsIterator iterator = new _SelectItemsIterator(component, facesContext);
                        converter = _SharedRendererUtils.getSelectItemsValueConverter(iterator, facesContext);
                    }
                    if (Collection.class.isAssignableFrom(modelType)) {
                        void var4_8;
                        Object collectionTypeAttr = component.getAttributes().get(COLLECTION_TYPE_KEY);
                        if (collectionTypeAttr != null) {
                            Class<?> collectionType = _SharedRendererUtils.getClassFromAttribute(facesContext, collectionTypeAttr);
                            if (collectionType == null) {
                                throw new FacesException("The attribute collectionType of component " + component.getClientId() + " does not evaluate to a " + "String, a Class object or a ValueExpression pointing " + "to a String or a Class object.");
                            }
                            if (!Collection.class.isAssignableFrom(collectionType)) {
                                throw new FacesException("The attribute collectionType of component " + component.getClientId() + " does not point to a valid type of Collection.");
                            }
                            try {
                                Object obj = collectionType.newInstance();
                            }
                            catch (Exception e) {
                                throw new FacesException("The Collection " + collectionType.getName() + "can not be instantiated.", e);
                            }
                        }
                        Collection componentValue = (Collection)component.getValue();
                        if (componentValue instanceof Cloneable) {
                            try {
                                Method cloneMethod = componentValue.getClass().getMethod("clone", new Class[0]);
                                Collection clone = (Collection)cloneMethod.invoke((Object)componentValue, new Object[0]);
                                clone.clear();
                                Collection collection = clone;
                            }
                            catch (Exception e) {
                                _SharedRendererUtils.log(facesContext, "Could not clone " + componentValue.getClass().getName(), e);
                            }
                        }
                        if (var4_8 == null) {
                            try {
                                Object obj = (componentValue != null ? componentValue.getClass() : modelType).newInstance();
                            }
                            catch (Exception e) {
                                if (SortedSet.class.isAssignableFrom(modelType)) {
                                    TreeSet treeSet = new TreeSet();
                                    break block28;
                                }
                                if (Queue.class.isAssignableFrom(modelType)) {
                                    LinkedList linkedList = new LinkedList();
                                    break block28;
                                }
                                if (Set.class.isAssignableFrom(modelType)) {
                                    HashSet hashSet = new HashSet(submittedValue.length);
                                    break block28;
                                }
                                ArrayList arrayList = new ArrayList(submittedValue.length);
                            }
                        }
                    } else {
                        if (converter == null) {
                            return submittedValue;
                        }
                        Object[] objectArray = new Object[submittedValue.length];
                    }
                }
            } else {
                Object[] objectArray = new Object[submittedValue.length];
            }
        }
        boolean isArray = var4_18.getClass().isArray();
        for (int i = 0; i < submittedValue.length; ++i) {
            Object value = converter != null ? converter.getAsObject(facesContext, component, submittedValue[i]) : submittedValue[i];
            if (isArray) {
                Array.set(var4_18, i, value);
                continue;
            }
            ((Collection)var4_18).add(value);
        }
        return var4_18;
    }

    static Class<?> getClassFromAttribute(FacesContext facesContext, Object attribute) throws FacesException {
        Class type = null;
        if (attribute instanceof ValueExpression) {
            attribute = ((ValueExpression)attribute).getValue(facesContext.getELContext());
        }
        if (attribute instanceof String) {
            try {
                type = Class.forName((String)attribute);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException("Unable to find class " + attribute + " on the classpath.", cnfe);
            }
        } else if (attribute instanceof Class) {
            type = (Class)attribute;
        }
        return type;
    }

    static Converter getSelectItemsValueConverter(Iterator<SelectItem> iterator, FacesContext facesContext) {
        Converter converter = null;
        while (converter == null && iterator.hasNext()) {
            SelectItem item = iterator.next();
            if (item instanceof SelectItemGroup) {
                Iterator<SelectItem> groupIterator = Arrays.asList(((SelectItemGroup)item).getSelectItems()).iterator();
                converter = _SharedRendererUtils.getSelectItemsValueConverter(groupIterator, facesContext);
                continue;
            }
            Class<?> selectItemsType = item.getValue().getClass();
            if (String.class.equals(selectItemsType)) {
                return null;
            }
            try {
                converter = facesContext.getApplication().createConverter(selectItemsType);
            }
            catch (FacesException e) {}
        }
        return converter;
    }

    private static void log(FacesContext context, String msg, Exception e) {
        context.getExternalContext().log(msg, e);
    }
}

