/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionAttributeMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FineSessionAttributeStorage
implements SessionAttributeStorage<OutgoingAttributeGranularitySessionData> {
    private final SessionAttributeMarshaller marshaller;

    public FineSessionAttributeStorage(SessionAttributeMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public void store(Map<Object, Object> map, OutgoingAttributeGranularitySessionData sessionData) {
        Set removed;
        Map modified = sessionData.getModifiedSessionAttributes();
        if (modified != null) {
            for (Map.Entry entry : modified.entrySet()) {
                map.put(entry.getKey(), this.marshaller.marshal(entry.getValue()));
            }
        }
        if ((removed = sessionData.getRemovedSessionAttributes()) != null) {
            for (String attribute : removed) {
                map.remove(attribute);
            }
        }
    }

    @Override
    public Map<String, Object> load(Map<Object, Object> data) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            String attribute = (String)key;
            try {
                result.put(attribute, this.marshaller.unmarshal(entry.getValue()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Exception("Failed to unmarshal session attribute: " + attribute, e);
            }
        }
        return result;
    }
}

