/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.process.processor.ejb.jboss;

import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.LocalBindingMetaData;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

public class SetExplicitLocalJndiNameProcessor<T extends JBossMetaData>
implements JBossMetaDataProcessor<T> {
    private static final Logger log = Logger.getLogger(SetExplicitLocalJndiNameProcessor.class);
    public static final SetExplicitLocalJndiNameProcessor INSTANCE = new SetExplicitLocalJndiNameProcessor();

    @Override
    public T process(T metadata) throws ProcessingException {
        assert (metadata != null) : "Specified metadata was null";
        JBossEnterpriseBeansMetaData ejbs = ((JBossMetaData)metadata).getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData ejb : ejbs) {
            JBossSessionBeanMetaData smd;
            List<LocalBindingMetaData> localBindings;
            if (!ejb.isSession() && !ejb.isService() || (localBindings = (smd = (JBossSessionBeanMetaData)ejb).getLocalBindings()) == null || localBindings.size() == 0) continue;
            assert (localBindings.size() == 1) : "Currently only 1 @LocalBinding is supported for EJB " + smd.getName();
            LocalBindingMetaData localBinding = localBindings.get(0);
            String localJndiName = localBinding.getJndiName();
            assert (localJndiName != null && localJndiName.length() > 0) : "@LocalBinding.jndiName must be specified for EJB " + smd.getName();
            smd.setLocalJndiName(localJndiName);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Found and set @LocalBinding.jndiName for EJB " + smd.getName() + " to " + localJndiName));
        }
        return metadata;
    }
}

