/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptions;

@XmlType(name="methodType", propOrder={"descriptions", "ejbName", "methodIntf", "methodName", "methodParams"})
public class MethodMetaData
extends IdMetaDataImplWithDescriptions {
    private static final long serialVersionUID = -985973586611090108L;
    private String ejbName;
    private MethodInterfaceType methodInterface;
    private String methodName;
    private MethodParametersMetaData methodParams;

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        if (ejbName == null) {
            throw new IllegalArgumentException("Null ejbName");
        }
        this.ejbName = ejbName;
    }

    public MethodInterfaceType getMethodIntf() {
        return this.methodInterface;
    }

    @XmlElement(name="method-intf")
    public void setMethodIntf(MethodInterfaceType methodInterface) {
        if (methodInterface == null) {
            throw new IllegalArgumentException("Null methodInterface");
        }
        this.methodInterface = methodInterface;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Null methodName");
        }
        this.methodName = methodName;
    }

    public MethodParametersMetaData getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(MethodParametersMetaData methodParams) {
        if (methodParams == null) {
            throw new IllegalArgumentException("Null methodParams");
        }
        this.methodParams = methodParams;
    }

    public boolean matches(String methodName, String[] params, MethodInterfaceType interfaceType) {
        if (methodName == null) {
            throw new IllegalArgumentException("Null methodName");
        }
        if (this.methodInterface != null && this.methodInterface != interfaceType) {
            return false;
        }
        if (this.getMethodName().equals("*")) {
            return true;
        }
        if (!this.getMethodName().equals(methodName)) {
            return false;
        }
        if (this.methodParams == null) {
            return true;
        }
        if (params == null && this.methodParams.size() > 0) {
            return false;
        }
        if (params != null && params.length != this.methodParams.size()) {
            return false;
        }
        int i = 0;
        for (String param : this.methodParams) {
            if (param.equals(params[i++])) continue;
            return false;
        }
        return true;
    }

    public boolean isHomeMethod() {
        return MethodInterfaceType.Home == this.methodInterface;
    }

    public boolean isRemoteMethod() {
        return MethodInterfaceType.Remote == this.methodInterface;
    }

    public boolean isLocalHomeMethod() {
        return MethodInterfaceType.LocalHome == this.methodInterface;
    }

    public boolean isLocalMethod() {
        return MethodInterfaceType.Local == this.methodInterface;
    }

    public boolean isServiceEndpointMethod() {
        return MethodInterfaceType.ServiceEndpoint == this.methodInterface;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("MethodMetaData(");
        tmp.append("ejbName=");
        tmp.append(this.ejbName);
        tmp.append(",interface=");
        tmp.append((Object)this.methodInterface);
        tmp.append(",method=");
        tmp.append(this.methodName);
        tmp.append(",params=");
        tmp.append(this.methodParams);
        tmp.append(')');
        return tmp.toString();
    }
}

