/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.junit;

import java.net.URL;
import java.util.UUID;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.junit.MicrocontainerTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrocontainerTest
extends AbstractTestCaseWithSetup {
    private boolean autowireCandidate;
    private String testBeanName;
    private KernelDeployment methodDeployment;

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new MicrocontainerTestDelegate(clazz);
    }

    public MicrocontainerTest(String name) {
        super(name);
    }

    public MicrocontainerTest(String name, boolean autowireCandidate) {
        super(name);
        this.autowireCandidate = autowireCandidate;
    }

    protected void setUp() throws Exception {
        super.setUp();
        URL url = this.getMethodResource();
        if (url != null) {
            this.methodDeployment = this.deploy(url);
        } else {
            this.getLog().debugf("No method specific deployment %1s", new Object[]{this.getMethodDeployment()});
        }
        this.afterSetUp();
    }

    protected String getMethodDeployment() {
        String testName = ((Object)((Object)this)).getClass().getName();
        return "/" + testName.replace('.', '/') + "#" + this.getName() + ".xml";
    }

    protected URL getMethodResource() {
        return this.getResource(this.getMethodDeployment());
    }

    protected void afterSetUp() throws Exception {
        if (this.autowireCandidate) {
            this.autowireThis();
        }
        this.configureLogging();
        this.getMCDelegate().validate();
    }

    protected void tearDown() throws Exception {
        if (this.methodDeployment != null) {
            this.undeploy(this.methodDeployment);
        }
        if (this.autowireCandidate) {
            this.clearAutowire();
        }
        super.tearDown();
    }

    protected void autowireThis() throws Exception {
        String beanName = this.createTestBeanName();
        KernelController controller = this.getController();
        try {
            controller.install(new AbstractBeanMetaData(beanName, ((Object)((Object)this)).getClass().getName()), (Object)this);
            this.testBeanName = beanName;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    protected String createTestBeanName() {
        return UUID.randomUUID().toString();
    }

    protected void clearAutowire() {
        if (this.testBeanName != null) {
            try {
                KernelController controller = this.getController();
                controller.uninstall(this.testBeanName);
            }
            catch (Exception e) {
                this.getLog().warn((Object)("Exception while uninstalling test instance: " + e));
            }
        }
    }

    private KernelController getController() {
        MicrocontainerTestDelegate delegate = this.getMCDelegate();
        Kernel kernel = delegate.kernel;
        return kernel.getController();
    }

    protected Object getBean(Object name) {
        return this.getBean(name, ControllerState.INSTALLED);
    }

    protected Object getBean(Object name, ControllerState state) {
        return this.getMCDelegate().getBean(name, state);
    }

    protected <T> T assertBean(Object name, ControllerState state, Class<T> expected) {
        return this.getMCDelegate().getBean(name, state, expected);
    }

    protected <T> T assertBean(Object name, Class<T> expected) {
        return this.assertBean(name, ControllerState.INSTALLED, expected);
    }

    protected void assertNoBean(Object name) {
        this.assertNoBean(name, ControllerState.INSTALLED);
    }

    protected void assertNoBean(Object name, ControllerState state) {
        this.assertNoControllerContext(name, state);
    }

    protected KernelControllerContext getControllerContext(Object name) {
        return this.getControllerContext(name, ControllerState.INSTALLED);
    }

    protected KernelControllerContext getControllerContext(Object name, ControllerState state) {
        return this.getMCDelegate().getControllerContext(name, state);
    }

    protected void assertNoControllerContext(Object name, ControllerState state) {
        this.getMCDelegate().assertNoControllerContext(name, state);
    }

    public ControllerState change(KernelControllerContext context, ControllerState required) throws Throwable {
        return this.getMCDelegate().change(context, required);
    }

    protected KernelDeployment deploy(URL url) throws Exception {
        return this.getMCDelegate().deploy(url);
    }

    protected KernelDeployment deploy(String resource) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + resource);
        }
        return this.getMCDelegate().deploy(url);
    }

    protected KernelControllerContext deploy(BeanMetaData beanMetaData) throws Exception {
        return this.getMCDelegate().deploy(beanMetaData);
    }

    protected void deploy(KernelDeployment deployment) throws Exception {
        this.getMCDelegate().deploy(deployment);
    }

    protected void undeploy(KernelControllerContext context) {
        this.getMCDelegate().undeploy(context);
    }

    protected void undeploy(KernelDeployment deployment) {
        this.getMCDelegate().undeploy(deployment);
    }

    protected void undeploy(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + resource);
        }
        this.getMCDelegate().undeploy(url);
    }

    protected void validate() throws Exception {
        this.getMCDelegate().validate();
    }

    protected KernelMetaDataRepository getMetaDataRepository() {
        return this.getMCDelegate().getMetaDataRepository();
    }

    protected void shutdown() {
        this.getMCDelegate().shutdown();
    }

    protected MicrocontainerTestDelegate getMCDelegate() {
        return (MicrocontainerTestDelegate)this.getDelegate();
    }

    protected void setAutowireCandidate(boolean autowireCandidate) {
        this.autowireCandidate = autowireCandidate;
    }
}

