/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.api.annotations.FactoryMethod;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.kernel.plugins.annotations.AbstractMethodParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMethodAnnotationPlugin
extends AbstractMethodParameterAnnotationPlugin<FactoryMethod, AbstractConstructorMetaData> {
    public FactoryMethodAnnotationPlugin(Map<Class<? extends Annotation>, Annotation2ValueMetaDataAdapter<? extends Annotation>> adapters) {
        super(FactoryMethod.class, adapters);
    }

    @Override
    protected boolean checkAnnotatedInfo(ElementType type) {
        return ElementType.METHOD == type;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(MethodInfo info, FactoryMethod annotation, BeanMetaData beanMetaData) {
        if (!info.isPublic() || !info.isStatic()) {
            throw new IllegalArgumentException("Method marked as @FactoryMethod must be public and static");
        }
        return beanMetaData.getConstructor() != null;
    }

    @Override
    protected ParameterInfo[] getParameters(MethodInfo info) {
        return info.getParameters();
    }

    @Override
    protected List<? extends MetaDataVisitorNode> handleParameterlessInfo(MethodInfo info, FactoryMethod annotation, BeanMetaData beanMetaData) {
        AbstractConstructorMetaData constructorMetaData = this.createParametrizedMetaData(info, annotation, beanMetaData);
        this.setParameterizedMetaData(constructorMetaData, beanMetaData);
        return Collections.singletonList(constructorMetaData);
    }

    @Override
    protected AbstractConstructorMetaData createParametrizedMetaData(MethodInfo info, FactoryMethod annotation, BeanMetaData beanMetaData) {
        AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
        constructor.setFactoryClass(beanMetaData.getBean());
        constructor.setFactoryMethod(info.getName());
        return constructor;
    }

    @Override
    protected void setParameterizedMetaData(AbstractConstructorMetaData parameterizedMetaData, BeanMetaData beanMetaData) {
        AbstractBeanMetaData abmd = this.checkIfNotAbstractBeanMetaDataSpecific(beanMetaData);
        abmd.setConstructor(parameterizedMetaData);
    }
}

