/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPageWithPro20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.util.BundleUtility;
import org.xmind.core.Core;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.exports.outline.ExportContent;
import org.xmind.ui.internal.exports.outline.ExportFormat;
import org.xmind.ui.internal.exports.outline.Messages;
import org.xmind.ui.internal.exports.outline.OutlineDocumentExporter;
import org.xmind.ui.internal.exports.outline.OutlinePlugin;
import org.xmind.ui.internal.exports.outline.OutlineTextExporter;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IViewerModel;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExporter;

public class OutlineExportWizard
extends AbstractMindMapExportWizard {
    private static final String OUTLINE_EXPORT_PAGE_NAME = "org.xmind.ui.export.outlineExportPage";
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.outline";
    private static final String FORMAT = "format";
    private static final String PDF_EXT = ".pdf";
    private static final String DOC_EXT = ".doc";
    private static final String DOCX_EXT = ".docx";
    private static final String TEXT_EXT = ".txt";
    private ExportFormat format;
    private FileDialog fileDialog;
    private boolean currentSheetOnly;
    private OutlineExportPage page;

    public OutlineExportWizard() {
        this.setWindowTitle(Messages.OutlineExportWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(OutlinePlugin.getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
        this.setNeedsProgressMonitor(true);
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPageWithPro20141031("ExportOutline", Messages.OutlineExportPage_Title));
        this.page = new OutlineExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 100);
        monitor.subTask(WizardMessages.Export_Initializing);
        IExporter exporter = this.createExporter();
        if (exporter == null) {
            throw new InterruptedException();
        }
        String format = this.getDialogSettings().get("exportFormat");
        ExportFormat exportFormat = ExportFormat.valueOf(format);
        switch (exportFormat) {
            case TEXT: {
                VerifyUI20141031.getUsageDataCollector().increase("ExportOutlineToTextCount");
                this.exportText(monitor, display, parentShell, exporter);
                break;
            }
            case PDF: {
                VerifyUI20141031.getUsageDataCollector().increase("ExportOutlineToPDFCount");
                this.exportDocument(monitor, display, parentShell, exporter);
                break;
            }
            case WORD: {
                VerifyUI20141031.getUsageDataCollector().increase("ExportOutlineToWordCount");
                this.exportDocument(monitor, display, parentShell, exporter);
                break;
            }
            default: {
                this.exportDocument(monitor, display, parentShell, exporter);
            }
        }
        this.launchTargetFile(true, monitor, display, parentShell);
        monitor.done();
    }

    private void exportText(IProgressMonitor monitor, Display display, Shell parentShell, IExporter exporter) throws InvocationTargetException, InterruptedException {
        FileOutputStream fileOut;
        monitor.worked(10);
        int total = exporter.getTotalWork();
        int worked = 0;
        int uiTotal = 88;
        int uiWorked = 0;
        try {
            fileOut = new FileOutputStream(this.getTargetPath());
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        try {
            OutputStream out = this.wrapMonitor(fileOut, monitor);
            try {
                PrintStream ps = this.createPrintStream(out);
                try {
                    ((OutlineTextExporter)exporter).setPrintStream(ps);
                    if (!exporter.canStart()) {
                        this.page.setErrorMessage(WizardMessages.TextExportPage_NoContentToExport_message);
                        throw new InterruptedException();
                    }
                    exporter.start(display, parentShell);
                    while (exporter.hasNext()) {
                        monitor.subTask(this.cleanFileName(exporter.getNextName()));
                        exporter.writeNext(monitor);
                        int newUIWorked = ++worked * uiTotal / total;
                        if (newUIWorked <= uiWorked) continue;
                        monitor.worked(newUIWorked - uiWorked);
                        uiWorked = newUIWorked;
                    }
                }
                finally {
                    ps.close();
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)fileOut).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)fileOut).close();
        }
        catch (IOException iOException) {}
        if (uiWorked < uiTotal) {
            monitor.worked(uiTotal - uiWorked);
        }
        monitor.subTask(WizardMessages.Export_Finishing);
        exporter.end();
        monitor.worked(1);
    }

    private PrintStream createPrintStream(OutputStream out) {
        try {
            return new UnicodePrintStream(out);
        }
        catch (UnsupportedEncodingException e) {
            Logger.log((Throwable)e, (String)"Unable to export text with utf-8 encoding.");
            return new PrintStream(out);
        }
    }

    private void exportDocument(IProgressMonitor monitor, Display display, Shell parentShell, IExporter exporter) throws InterruptedException, InvocationTargetException {
        if (!exporter.canStart()) {
            throw new InterruptedException();
        }
        exporter.start(display, parentShell);
        monitor.worked(10);
        int total = exporter.getTotalWork();
        int worked = 0;
        int uiTotal = 88;
        int uiWorked = 0;
        while (exporter.hasNext()) {
            monitor.subTask(this.cleanFileName(exporter.getNextName()));
            exporter.writeNext(monitor);
            int newUIWorked = ++worked * uiTotal / total;
            if (newUIWorked <= uiWorked) continue;
            monitor.worked(newUIWorked - uiWorked);
            uiWorked = newUIWorked;
        }
        if (uiWorked < uiTotal) {
            monitor.worked(uiTotal - uiWorked);
        }
        monitor.subTask(WizardMessages.Export_Finishing);
        exporter.end();
        monitor.worked(1);
    }

    private IExporter createExporter() {
        Exporter exporter;
        IMindMap mindmap = this.getSourceMindMap();
        ISheet sheet = mindmap.getSheet();
        ITopic centralTopic = mindmap.getCentralTopic();
        String format = this.getDialogSettings().get("exportFormat");
        ExportFormat exportFormat = ExportFormat.valueOf(format);
        String content = this.getDialogSettings().get("exportContent");
        switch (exportFormat) {
            case TEXT: {
                exporter = new OutlineTextExporter(sheet, centralTopic, ExportContent.currentSheetOnly(content));
                break;
            }
            case WORD: {
                int version = this.getVersion();
                exporter = new OutlineDocumentExporter(sheet, centralTopic, ExportContent.currentSheetOnly(content), this.getTargetPath(), version);
                break;
            }
            default: {
                exporter = new OutlineDocumentExporter(sheet, centralTopic, ExportContent.currentSheetOnly(content), this.getTargetPath(), 1);
            }
        }
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    private int getVersion() {
        if (this.fileDialog == null) {
            return 2;
        }
        int filterIndex = this.fileDialog.getFilterIndex();
        String filterExtension = this.fileDialog.getFilterExtensions()[filterIndex];
        if ("*.docx".equals(filterExtension)) {
            String target = this.getTargetPath();
            if (!target.contains(DOCX_EXT)) {
                this.setTargetPath(String.valueOf(target) + "x");
            }
            return 3;
        }
        return 2;
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        String mediaType = settings.get(FORMAT);
        ExportFormat lastFormat = ExportFormat.findByMediaType(mediaType, ExportFormat.PDF);
        this.setFormat(lastFormat);
        super.loadDialogSettings(settings);
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        super.saveDialogSettings(settings);
        if (this.format != null) {
            settings.put(FORMAT, this.format.getMediaType());
        }
    }

    public ExportFormat getFormat() {
        return this.format;
    }

    public void setFormat(ExportFormat format) {
        this.format = format;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public boolean isCurrentSheetOnly() {
        return this.currentSheetOnly;
    }

    public void setCurrentSheetOnly(boolean currentSheetOnly) {
        this.currentSheetOnly = currentSheetOnly;
    }

    protected String getFormatName() {
        return this.hasFormat() ? "'" + this.getFormat().getName() + "'" : "";
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && this.hasFormat() && this.getFormat().getFileExtendions().contains(extension.toLowerCase());
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + this.getFormat().getFileExtendions().get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OutlineExportPage
    extends AbstractMindMapExportPage {
        private GraphicalViewer previewViewer;

        public OutlineExportPage() {
            super(OutlineExportWizard.OUTLINE_EXPORT_PAGE_NAME, Messages.OutlineExportPage_Title);
            this.previewViewer = null;
            this.setDescription(Messages.OutlineExportPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            String format = this.getDialogSettings().get("exportFormat");
            ExportFormat exportFormat = ExportFormat.valueOf(format);
            switch (exportFormat) {
                case TEXT: {
                    filterNames.add(0, Messages.TextPage_FilterName);
                    filterExtensions.add(0, "*.txt");
                    break;
                }
                case WORD: {
                    filterNames.add(0, Messages.Word2007Page_FilterName);
                    filterExtensions.add(0, "*.docx");
                    filterNames.add(0, Messages.WordPage_FilterName);
                    filterExtensions.add(0, "*.doc");
                    break;
                }
                case PDF: {
                    filterNames.add(0, Messages.PDFPage_FilterName);
                    filterExtensions.add(0, "*.pdf");
                }
            }
            OutlineExportWizard.this.fileDialog = dialog;
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control settingsGroup = this.createSettingsGroup(composite);
            settingsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        protected Control createSettingsGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(WizardMessages.DocumentExportPage_SettingsGroup_title);
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 20;
            layout.marginWidth = 7;
            layout.marginHeight = 7;
            group.setLayout((Layout)layout);
            Composite widgetContainer = new Composite((Composite)group, 0);
            widgetContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout containerLayout = new GridLayout(1, false);
            containerLayout.marginHeight = 0;
            containerLayout.marginWidth = 0;
            containerLayout.verticalSpacing = 7;
            widgetContainer.setLayout((Layout)containerLayout);
            this.createPropertyWidgets(widgetContainer);
            Composite previewContainer = new Composite((Composite)group, 0);
            GridData previewLayoutData = new GridData(0x1000008, 4, false, true);
            previewLayoutData.widthHint = 260;
            previewLayoutData.heightHint = 330;
            previewContainer.setLayoutData((Object)previewLayoutData);
            GridLayout previewLayout = new GridLayout(1, false);
            previewLayout.marginHeight = 0;
            previewLayout.marginWidth = 0;
            previewContainer.setLayout((Layout)previewLayout);
            this.createPreviewViewer(previewContainer);
            return group;
        }

        private void createPropertyWidgets(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginTop = 30;
            layout.marginLeft = 0;
            layout.verticalSpacing = 30;
            layout.horizontalSpacing = 20;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout labelLayout = new GridLayout();
            labelLayout.marginTop = 0;
            labelLayout.verticalSpacing = 10;
            labelLayout.horizontalSpacing = 0;
            Composite labelGroup1 = new Composite(composite, 0);
            labelGroup1.setLayout((Layout)labelLayout);
            Label contentLabel = new Label(labelGroup1, 0);
            contentLabel.setText(Messages.OutlineExportPage_ContentGroup);
            Composite contentGroup = new Composite(labelGroup1, 0);
            this.initGroup(contentGroup);
            this.createContentRadio(contentGroup, ExportContent.Current);
            this.createContentRadio(contentGroup, ExportContent.Workbook);
            Composite labelGroup2 = new Composite(composite, 0);
            labelGroup2.setLayout((Layout)labelLayout);
            Label formatLabel = new Label(labelGroup2, 0);
            formatLabel.setText(Messages.OutlineExportPage_FormatGroup);
            Composite formatGroup = new Composite(labelGroup2, 0);
            this.initGroup(formatGroup);
            this.createFormatRadio(formatGroup, ExportFormat.TEXT);
            this.createFormatRadio(formatGroup, ExportFormat.PDF);
            this.createFormatRadio(formatGroup, ExportFormat.WORD);
        }

        private void initGroup(Composite group) {
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 10;
            gridLayout.marginTop = 0;
            gridLayout.verticalSpacing = 0;
            group.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(4, 4, false, false);
            gridData.widthHint = 210;
            gridData.heightHint = -1;
            group.setLayoutData((Object)gridData);
        }

        private void createContentRadio(Composite parent, final ExportContent content) {
            final Button radio = new Button(parent, 16);
            radio.setText(content.getValue());
            radio.setData((Object)content.getKey());
            radio.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            radio.setSelection(this.getExportContentSelection(content));
            radio.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (radio.getSelection()) {
                        OutlineExportPage.this.getDialogSettings().put("exportContent", content.getKey());
                        OutlineExportPage.this.updateStatus();
                        OutlineExportWizard.this.setCurrentSheetOnly(ExportContent.currentSheetOnly(content.getKey()));
                        OutlineExportPage.this.updatePreview(content.getKey(), OutlineExportPage.this.getDialogSettings().get("exportContent"));
                    }
                }
            });
        }

        private void createFormatRadio(Composite parent, final ExportFormat format) {
            Button radio = new Button(parent, 16);
            radio.setText(format.getName());
            radio.setData((Object)format);
            radio.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            radio.setSelection(this.getExportFormatSelection(format));
            radio.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    OutlineExportPage.this.getDialogSettings().put("exportFormat", format.toString());
                    OutlineExportPage.this.updateStatus();
                    ExportFormat oldFormat = OutlineExportWizard.this.getFormat();
                    OutlineExportWizard.this.setFormat(format);
                    if (oldFormat != OutlineExportWizard.this.getFormat()) {
                        OutlineExportPage.this.formatChanged();
                    }
                }
            });
        }

        private void formatChanged() {
            String ext;
            List<String> exts;
            if (this.hasTargetPath() && OutlineExportWizard.this.hasFormat() && !(exts = OutlineExportWizard.this.getFormat().getFileExtendions()).contains(ext = FileUtils.getExtension((String)this.getTargetPath()))) {
                this.setTargetPath(this.replaceExtension(this.getTargetPath(), ext, exts.get(0)));
            }
            this.updateStatus();
        }

        private String replaceExtension(String path, String oldExt, String newExt) {
            return String.valueOf(path.substring(0, path.length() - oldExt.length())) + newExt;
        }

        private boolean getExportContentSelection(ExportContent content) {
            boolean isSelection;
            String exportContent = this.getDialogSettings().get("exportContent");
            if (exportContent == null) {
                exportContent = ExportContent.Current.getKey();
            }
            if (isSelection = exportContent.equals(content.getKey())) {
                this.getDialogSettings().put("exportContent", exportContent);
            }
            return isSelection;
        }

        private boolean getExportFormatSelection(ExportFormat format) {
            boolean isSelection;
            String exportFormat = this.getDialogSettings().get("exportFormat");
            ExportFormat selection = exportFormat == null ? ExportFormat.PDF : ExportFormat.valueOf(exportFormat);
            boolean bl = isSelection = format == selection;
            if (isSelection) {
                this.getDialogSettings().put("exportFormat", selection.name());
            }
            return isSelection;
        }

        private void createPreviewViewer(Composite parent) {
            this.previewViewer = new GalleryViewer();
            this.initPreviewViewer(this.previewViewer);
            this.previewViewer.createControl(parent);
            GridData gridData = new GridData(4, 4, true, true);
            this.previewViewer.getControl().setLayoutData((Object)gridData);
            this.previewViewer.getControl().setBackground(null);
            if (!"win32".equals(SWT.getPlatform())) {
                this.previewViewer.getCanvas().getLightweightSystem().getRootFigure().setOpaque(false);
            }
            this.previewViewer.setInput(this.getPreviewViewerInput());
        }

        private void initPreviewViewer(GraphicalViewer previewViewer) {
            previewViewer.setPartFactory((IPartFactory)new PreviewPartFactory(previewViewer.getPartFactory()));
            Properties properties = previewViewer.getProperties();
            properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.FALSE);
            properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout().margins(0));
        }

        private void updatePreview(String string, String string2) {
        }

        private Object getPreviewViewerInput() {
            return this.createSampleSheet();
        }

        private ISheet createSampleSheet() {
            IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook();
            ISheet sheet = workbook.getPrimarySheet();
            ITopic rootTopic = sheet.getRootTopic();
            rootTopic.setTitleText(WizardMessages.DocumentExportPage_Sample_CentralTopic);
            ITopic mainTopic1 = workbook.createTopic();
            rootTopic.add(mainTopic1);
            mainTopic1.setTitleText(WizardMessages.DocumentExportPage_Sample_MainTopic1);
            ITopic sub1 = workbook.createTopic();
            sub1.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic1);
            mainTopic1.add(sub1);
            ITopic sub2 = workbook.createTopic();
            sub2.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic2);
            mainTopic1.add(sub2);
            ITopic sub3 = workbook.createTopic();
            sub3.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic3);
            mainTopic1.add(sub3);
            ITopic summary = workbook.createTopic();
            summary.setTitleText(WizardMessages.DocumentExportPage_Sample_Summary);
            sub1.add(summary, "summary");
            sub2.add(summary, "summary");
            sub3.add(summary, "summary");
            ITopic sub31 = workbook.createTopic();
            sub31.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic1);
            sub3.add(sub31);
            ITopic sub32 = workbook.createTopic();
            sub32.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic2);
            sub3.add(sub32);
            ITopic mainTopic2 = workbook.createTopic();
            rootTopic.add(mainTopic2);
            mainTopic2.setTitleText(WizardMessages.DocumentExportPage_Sample_MainTopic2);
            ITopic mainTopic3 = workbook.createTopic();
            rootTopic.add(mainTopic3);
            mainTopic3.setTitleText(WizardMessages.DocumentExportPage_Sample_MainTopic3);
            ITopic sub4 = workbook.createTopic();
            sub4.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic1);
            mainTopic3.add(sub4);
            ITopic callout = workbook.createTopic();
            callout.setTitleText(WizardMessages.DocumentExportPage_Sample_Callout);
            mainTopic3.add(callout, "callout");
            ITopic floating = workbook.createTopic();
            floating.setTitleText(WizardMessages.DocumentExportPage_Sample_FloatingTopic);
            rootTopic.add(floating, "detached");
            return sheet;
        }

        private class PreviewPartFactory
        implements IPartFactory {
            private IPartFactory factory;

            public PreviewPartFactory(IPartFactory factory) {
                this.factory = factory;
            }

            public IPart createPart(IPart context, Object model) {
                if (model instanceof ISheet && context instanceof FramePart) {
                    return new SheetPreviewPart((ISheet)model);
                }
                if (model instanceof IViewerModel) {
                    IViewerModel m = (IViewerModel)model;
                    try {
                        IPart part = (IPart)m.getPartType().getConstructors()[0].newInstance(new Object[]{OutlineExportPage.this});
                        part.setModel(model);
                        return part;
                    }
                    catch (Throwable e) {
                        Logger.log((Throwable)e, (String)("Failed to create export preview part: " + m.getPartType()));
                    }
                }
                return this.factory.createPart(context, model);
            }
        }

        private class SheetPreviewPart
        extends GraphicalEditPart {
            public SheetPreviewPart(ISheet sheet) {
                this.setModel(sheet);
            }

            protected IFigure createFigure() {
                return new Figure();
            }

            protected void initFigure(IFigure figure) {
                super.initFigure(figure);
                figure.setBorder((Border)new MarginBorder(10));
                figure.setPreferredSize(new Dimension(240, 310));
            }

            protected LayoutManager createLayoutManager() {
                AdvancedToolbarLayout layout = new AdvancedToolbarLayout(false);
                layout.setMajorAlignment(1);
                layout.setStretchMinorAxis(true);
                layout.setSpacing(2);
                return layout;
            }

            public ISheet getSheet() {
                return (ISheet)super.getModel();
            }

            protected Object[] getModelChildren(Object model) {
                ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
                ISheet sheet = this.getSheet();
                ITopic rootTopic = sheet.getRootTopic();
                list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)rootTopic));
                List children = rootTopic.getChildren("attached");
                for (ITopic mainTopic : children) {
                    list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)mainTopic));
                    for (ITopic sub : mainTopic.getChildren("attached")) {
                        list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)sub));
                        for (ITopic t : sub.getChildren("summary")) {
                            list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)t));
                        }
                        for (ITopic sub3 : sub.getChildren("attached")) {
                            list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)sub3));
                        }
                    }
                    for (ITopic c : mainTopic.getChildren("callout")) {
                        list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)c));
                    }
                }
                for (ITopic t : rootTopic.getChildren("detached")) {
                    list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)t));
                }
                return list.toArray();
            }
        }

        private class TopicTitlePreviewPart
        extends GraphicalEditPart {
            private RotatableWrapLabel title;

            public ITopic getTopic() {
                return (ITopic)MindMapUtils.getRealModel((IPart)this);
            }

            protected IFigure createFigure() {
                return new Figure();
            }

            protected LayoutManager createLayoutManager() {
                AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
                if (this.getTopic().isRoot()) {
                    layout.setMajorAlignment(1);
                } else {
                    layout.setMajorAlignment(1);
                }
                layout.setMinorAlignment(2);
                layout.setInnerMinorAlignment(2);
                layout.setSpacing(5);
                return layout;
            }

            protected void initFigure(IFigure figure) {
                Image image;
                Font font;
                StringBuilder sb;
                ITopic topic;
                block24: {
                    URL url;
                    super.initFigure(figure);
                    topic = this.getTopic();
                    int level = MindMapUtils.getLevel((ITopic)this.getTopic(), null);
                    sb = new StringBuilder();
                    if ("summary".equals(topic.getType())) {
                        --level;
                    }
                    int i = 0;
                    while (i < level) {
                        sb.append("    ");
                        ++i;
                    }
                    font = null;
                    String calibri = "Calibri";
                    font = topic.isRoot() ? FontUtils.getFont((String)"Calibri Light", (int)20, (boolean)false, (boolean)false) : (level == 1 ? ("attached".equals(topic.getType()) ? FontUtils.getFont((String)calibri, (int)10, (boolean)false, (boolean)false) : FontUtils.getFont((String)calibri, (int)8, (boolean)false, (boolean)false)) : (level == 2 ? ("attached".equals(topic.getType()) ? FontUtils.getFont((String)calibri, (int)8, (boolean)true, (boolean)false) : FontUtils.getFont((String)calibri, (int)8, (boolean)false, (boolean)true)) : FontUtils.getFont((String)calibri, (int)8, (boolean)false, (boolean)false)));
                    image = null;
                    String path = "icons/";
                    if ("detached".equals(topic.getType())) {
                        path = String.valueOf(path) + "bullet_3.png";
                    } else if ("attached".equals(topic.getType())) {
                        if (level == 2) {
                            path = String.valueOf(path) + "bullet_1.png";
                        }
                        if (level == 3) {
                            path = String.valueOf(path) + "bullet_2.png";
                        }
                    }
                    if (!path.equals("icons/") && (url = BundleUtility.find((String)"org.xmind.ui.exports.outline", (String)path)) != null) {
                        InputStream stream = null;
                        try {
                            try {
                                stream = url.openStream();
                                image = new Image((Device)Display.getCurrent(), stream);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                if (stream != null) {
                                    try {
                                        stream.close();
                                        stream = null;
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                    stream = null;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                                stream = null;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                this.title = new RotatableWrapLabel(0);
                this.title.setFont(font);
                this.title.setForegroundColor("summary".equals(topic.getType()) ? ColorUtils.getColor((String)"#823c14") : ColorConstants.black);
                if (image == null) {
                    this.title.setText(String.valueOf(sb.toString()) + topic.getTitleText());
                } else {
                    RotatableWrapLabel pre = new RotatableWrapLabel(0);
                    pre.setFont(font);
                    pre.setText(sb.toString());
                    figure.add((IFigure)pre);
                    org.eclipse.draw2d.Label label = new org.eclipse.draw2d.Label();
                    label.setIcon(image);
                    figure.add((IFigure)label);
                    this.title.setText(topic.getTitleText());
                }
                figure.add((IFigure)this.title);
            }
        }
    }

    private static class UnicodePrintStream
    extends PrintStream {
        public UnicodePrintStream(OutputStream out) throws UnsupportedEncodingException {
            super(out, false, "utf-8");
        }
    }
}

