/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.IResourceRef;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.util.HyperlinkUtils;

public class ExtensionsDeserializer {
    public void deserialize(IWorkbookExtensionManager extensionManager, JSONObject extensionsObject) {
        JSONArray extArray = extensionsObject.optJSONArray("extensions");
        if (extArray != null) {
            for (Object extObject : extArray) {
                if (!(extObject instanceof JSONObject)) continue;
                this.deserializeWorkbookExtension(extensionManager, (JSONObject)extObject);
            }
        }
    }

    private void deserializeWorkbookExtension(IWorkbookExtensionManager extensionManager, JSONObject extObject) {
        String providerName = extObject.optString("provider", null);
        Assert.isNotNull((Object)providerName);
        IWorkbookExtension ext = extensionManager.createExtension(providerName);
        this.deserializeWorkbookExtensionElement(ext.getContent(), extObject);
        JSONArray resourceRefArray = extObject.optJSONArray("resourceRefs");
        if (resourceRefArray != null) {
            for (Object resourceRefArrayElement : resourceRefArray) {
                String refURL;
                if (!(resourceRefArrayElement instanceof String) || !HyperlinkUtils.isAttachmentURL((String)(refURL = (String)resourceRefArrayElement))) continue;
                IResourceRef ref = ext.getOwnedWorkbook().createResourceRef("file-entry", HyperlinkUtils.toAttachmentPath((String)refURL));
                ext.addResourceRef(ref);
            }
        }
    }

    private void deserializeWorkbookExtensionElement(IWorkbookExtensionElement ele, JSONObject eleObject) {
        Object content;
        JSONObject attrMapObject = eleObject.optJSONObject("attrs");
        if (attrMapObject != null) {
            Iterator attrKeyIt = attrMapObject.keys();
            while (attrKeyIt.hasNext()) {
                String attrKey = (String)attrKeyIt.next();
                ele.setAttribute(attrKey, attrMapObject.getString(attrKey));
            }
        }
        if ((content = eleObject.opt("content")) instanceof String) {
            ele.setTextContent((String)content);
        } else if (content instanceof JSONArray) {
            JSONArray childElementArray = (JSONArray)content;
            for (Object childElementObject : childElementArray) {
                if (!(childElementObject instanceof JSONObject)) continue;
                String childName = ((JSONObject)childElementObject).optString("name", null);
                Assert.isNotNull((Object)childName);
                this.deserializeWorkbookExtensionElement((IWorkbookExtensionElement)ele.createChild(childName), (JSONObject)childElementObject);
            }
        }
    }
}

